/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public final class MockVariableLengthPayloadFilter
extends TokenFilter {
    private static final int MAXLENGTH = 129;
    private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final Random random;
    private final byte[] bytes = new byte[129];
    private final BytesRef payload;

    public MockVariableLengthPayloadFilter(Random random, TokenStream in) {
        super(in);
        this.random = random;
        this.payload = new BytesRef(this.bytes);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.random.nextBytes(this.bytes);
            this.payload.length = this.random.nextInt(129);
            this.payloadAtt.setPayload(this.payload);
            return true;
        }
        return false;
    }
}

