/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.docgen.processor.ElementImports;
import org.apache.logging.log4j.docgen.processor.internal.BlockImpl;
import org.apache.logging.log4j.docgen.processor.internal.DocumentImpl;
import org.apache.logging.log4j.docgen.processor.internal.SectionImpl;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;

final class AsciiDocData {
    private static final Pattern WHITESPACE_SEQUENCE = Pattern.compile("\\s+");
    private static final String SPACE = " ";
    private static final char SPACE_CHAR = ' ';
    private static final char CODE_CHAR = '`';
    final ElementImports imports;
    final String qualifiedClassName;
    private final Document document;
    private int currentSectionLevel;
    private StructuralNode currentNode;
    private final Deque<Block> paragraphs = new ArrayDeque<Block>();
    private final Deque<StringBuilder> lines = new ArrayDeque<StringBuilder>();

    public AsciiDocData(ElementImports imports, String qualifiedClassName) {
        this.imports = imports;
        this.qualifiedClassName = qualifiedClassName;
        this.document = new DocumentImpl();
        this.currentSectionLevel = 1;
        this.currentNode = this.document;
        this.paragraphs.push(new BlockImpl((ContentNode)this.currentNode));
        this.lines.push(new StringBuilder());
    }

    public void newLine() {
        String line = this.getCurrentLine().toString().stripTrailing();
        if (!this.getCurrentParagraph().getLines().isEmpty() || !line.isEmpty()) {
            this.getCurrentParagraph().getLines().add(line);
        }
        this.getCurrentLine().setLength(0);
    }

    public AsciiDocData append(String text) {
        String[] lines = text.split("\r?\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            this.getCurrentLine().append(lines[i]);
            if (i == lines.length - 1) continue;
            this.newLine();
        }
        return this;
    }

    public AsciiDocData appendAdjustingSpace(CharSequence text) {
        String normalized = WHITESPACE_SEQUENCE.matcher(text).replaceAll(SPACE);
        if (!normalized.isEmpty()) {
            StringBuilder currentLine = this.getCurrentLine();
            int lineLastChar = StringUtils.isEmpty((CharSequence)currentLine) ? 32 : (int)currentLine.charAt(currentLine.length() - 1);
            char textFirstChar = normalized.charAt(0);
            if (lineLastChar == 32 && textFirstChar == ' ') {
                currentLine.append(normalized, 1, normalized.length());
            } else if (lineLastChar == 96 && Character.isAlphabetic(textFirstChar)) {
                currentLine.append(' ').append(normalized);
            } else {
                currentLine.append(normalized);
            }
        }
        return this;
    }

    public void newTextSpan() {
        this.paragraphs.push(new BlockImpl((ContentNode)this.paragraphs.peek()));
        this.lines.push(new StringBuilder());
    }

    public String popTextSpan() {
        StringBuilder line = this.lines.peek();
        if (StringUtils.isNotEmpty((CharSequence)line)) {
            this.newLine();
        }
        this.lines.pop();
        return String.join((CharSequence)SPACE, this.paragraphs.pop().getLines());
    }

    public Block newParagraph() {
        return this.newParagraph(this.currentNode);
    }

    private Block newParagraph(StructuralNode parent) {
        this.newLine();
        Block currentParagraph = this.paragraphs.pop();
        List lines = currentParagraph.getLines();
        for (int i = lines.size() - 1; i >= 0 && ((String)lines.get(i)).isEmpty(); --i) {
            lines.remove(i);
        }
        if (!currentParagraph.getLines().isEmpty()) {
            this.currentNode.append((StructuralNode)currentParagraph);
        }
        this.paragraphs.push(new BlockImpl((ContentNode)parent));
        return currentParagraph;
    }

    public StructuralNode getCurrentNode() {
        return this.currentNode;
    }

    public Block getCurrentParagraph() {
        return this.paragraphs.peek();
    }

    public StringBuilder getCurrentLine() {
        return this.lines.peek();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setCurrentSectionLevel(int sectionLevel) {
        if (sectionLevel < this.currentSectionLevel) {
            while (sectionLevel < this.currentSectionLevel) {
                this.popNode();
                --this.currentSectionLevel;
            }
            this.popNode();
            this.pushChildNode(SectionImpl::new);
        } else {
            while (sectionLevel > this.currentSectionLevel) {
                this.pushChildNode(SectionImpl::new);
                ++this.currentSectionLevel;
            }
        }
    }

    public StructuralNode pushChildNode(Function<? super StructuralNode, ? extends StructuralNode> supplier) {
        StructuralNode child = supplier.apply((StructuralNode)this.currentNode);
        this.newParagraph(child);
        this.currentNode.append(child);
        this.currentNode = child;
        return this.currentNode;
    }

    public StructuralNode popNode() {
        StructuralNode currentNode = this.currentNode;
        StructuralNode parent = (StructuralNode)currentNode.getParent();
        if (parent == null) {
            throw new EmptyStackException();
        }
        this.newParagraph(parent);
        this.currentNode = parent;
        return currentNode;
    }
}

