/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.Description;
import org.apache.logging.log4j.docgen.PluginAttribute;
import org.apache.logging.log4j.docgen.PluginElement;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.ScalarType;
import org.apache.logging.log4j.docgen.ScalarValue;
import org.apache.logging.log4j.docgen.Type;
import org.apache.logging.log4j.docgen.io.stax.IndentingXMLStreamWriter;

public class PluginBundleStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, PluginSet pluginSet) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(pluginSet.getModelEncoding(), "1.0");
        this.writePluginSet(pluginSet, "pluginSet", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, PluginSet pluginSet) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, pluginSet.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(pluginSet.getModelEncoding(), "1.0");
        this.writePluginSet(pluginSet, "pluginSet", serializer);
        serializer.writeEndDocument();
    }

    private void writeAbstractType(AbstractType abstractType, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (abstractType != null) {
            serializer.writeStartElement(tagName);
            if (abstractType.getClassName() != null) {
                serializer.writeAttribute("className", abstractType.getClassName());
            }
            if (abstractType.getDescription() != null) {
                this.writeDescription(abstractType.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDescription(Description description, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (description != null) {
            serializer.writeStartElement(tagName);
            if (description.getFormat() != null && !description.getFormat().equals("asciidoc")) {
                serializer.writeAttribute("format", description.getFormat());
            }
            serializer.writeCharacters(description.getText());
            serializer.writeEndElement();
        }
    }

    private void writePluginAttribute(PluginAttribute pluginAttribute, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginAttribute != null) {
            serializer.writeStartElement(tagName);
            if (pluginAttribute.getName() != null) {
                serializer.writeAttribute("name", pluginAttribute.getName());
            }
            if (pluginAttribute.getType() != null && !pluginAttribute.getType().equals("java.lang.String")) {
                serializer.writeAttribute("type", pluginAttribute.getType());
            }
            if (pluginAttribute.isRequired()) {
                serializer.writeAttribute("required", String.valueOf(pluginAttribute.isRequired()));
            }
            if (pluginAttribute.getDefaultValue() != null) {
                serializer.writeAttribute("defaultValue", pluginAttribute.getDefaultValue());
            }
            if (pluginAttribute.getDefaultProperty() != null) {
                serializer.writeAttribute("defaultProperty", pluginAttribute.getDefaultProperty());
            }
            if (pluginAttribute.getDescription() != null) {
                this.writeDescription(pluginAttribute.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginElement(PluginElement pluginElement, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginElement != null) {
            serializer.writeStartElement(tagName);
            if (pluginElement.getMultiplicity() != null && !pluginElement.getMultiplicity().equals("1")) {
                serializer.writeAttribute("multiplicity", pluginElement.getMultiplicity());
            }
            if (pluginElement.isRequired()) {
                serializer.writeAttribute("required", String.valueOf(pluginElement.isRequired()));
            }
            if (pluginElement.getType() != null) {
                serializer.writeAttribute("type", pluginElement.getType());
            }
            if (pluginElement.getDescription() != null) {
                this.writeDescription(pluginElement.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginSet(PluginSet pluginSet, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginSet != null) {
            serializer.setDefaultNamespace("https://logging.apache.org/xml/ns");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("https://logging.apache.org/xml/ns");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "https://logging.apache.org/xml/ns https://logging.apache.org/xml/ns/log4j-plugins-0.1.0.xsd");
            if (pluginSet.getSchemaVersion() != null) {
                serializer.writeAttribute("version", pluginSet.getSchemaVersion());
            }
            if (pluginSet.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(pluginSet.getGroupId());
                serializer.writeEndElement();
            }
            if (pluginSet.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(pluginSet.getArtifactId());
                serializer.writeEndElement();
            }
            if (pluginSet.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(pluginSet.getVersion());
                serializer.writeEndElement();
            }
            if (pluginSet.getDescription() != null) {
                this.writeDescription(pluginSet.getDescription(), "description", serializer);
            }
            if (pluginSet.getScalars() != null && pluginSet.getScalars().size() > 0) {
                serializer.writeStartElement("scalars");
                for (ScalarType scalarType : pluginSet.getScalars()) {
                    this.writeScalarType(scalarType, "scalar", serializer);
                }
                serializer.writeEndElement();
            }
            if (pluginSet.getPlugins() != null && pluginSet.getPlugins().size() > 0) {
                serializer.writeStartElement("plugins");
                for (PluginType pluginType : pluginSet.getPlugins()) {
                    this.writePluginType(pluginType, "plugin", serializer);
                }
                serializer.writeEndElement();
            }
            if (pluginSet.getAbstractTypes() != null && pluginSet.getAbstractTypes().size() > 0) {
                serializer.writeStartElement("abstractTypes");
                for (AbstractType abstractType : pluginSet.getAbstractTypes()) {
                    this.writeAbstractType(abstractType, "abstractType", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginType(PluginType pluginType, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginType != null) {
            serializer.writeStartElement(tagName);
            if (pluginType.getName() != null) {
                serializer.writeAttribute("name", pluginType.getName());
            }
            if (pluginType.getNamespace() != null && !pluginType.getNamespace().equals("Core")) {
                serializer.writeAttribute("namespace", pluginType.getNamespace());
            }
            if (pluginType.isDeferChildren()) {
                serializer.writeAttribute("deferChildren", String.valueOf(pluginType.isDeferChildren()));
            }
            if (pluginType.getClassName() != null) {
                serializer.writeAttribute("className", pluginType.getClassName());
            }
            if (pluginType.getAliases() != null && pluginType.getAliases().size() > 0) {
                serializer.writeStartElement("aliases");
                for (String string : pluginType.getAliases()) {
                    serializer.writeStartElement("alias");
                    serializer.writeCharacters(string);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginType.getSupertypes() != null && pluginType.getSupertypes().size() > 0) {
                serializer.writeStartElement("supertypes");
                for (String string : pluginType.getSupertypes()) {
                    serializer.writeStartElement("supertype");
                    serializer.writeCharacters(string);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (pluginType.getAttributes() != null && pluginType.getAttributes().size() > 0) {
                serializer.writeStartElement("attributes");
                for (PluginAttribute pluginAttribute : pluginType.getAttributes()) {
                    this.writePluginAttribute(pluginAttribute, "attribute", serializer);
                }
                serializer.writeEndElement();
            }
            if (pluginType.getElements() != null && pluginType.getElements().size() > 0) {
                serializer.writeStartElement("elements");
                for (PluginElement pluginElement : pluginType.getElements()) {
                    this.writePluginElement(pluginElement, "element", serializer);
                }
                serializer.writeEndElement();
            }
            if (pluginType.getDescription() != null) {
                this.writeDescription(pluginType.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeScalarType(ScalarType scalarType, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (scalarType != null) {
            serializer.writeStartElement(tagName);
            if (scalarType.getClassName() != null) {
                serializer.writeAttribute("className", scalarType.getClassName());
            }
            if (scalarType.getValues() != null && scalarType.getValues().size() > 0) {
                serializer.writeStartElement("values");
                for (ScalarValue o : scalarType.getValues()) {
                    this.writeScalarValue(o, "value", serializer);
                }
                serializer.writeEndElement();
            }
            if (scalarType.getDescription() != null) {
                this.writeDescription(scalarType.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeScalarValue(ScalarValue scalarValue, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (scalarValue != null) {
            serializer.writeStartElement(tagName);
            if (scalarValue.getName() != null) {
                serializer.writeAttribute("name", scalarValue.getName());
            }
            if (scalarValue.getDescription() != null) {
                this.writeDescription(scalarValue.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeType(Type type, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (type != null) {
            serializer.writeStartElement(tagName);
            if (type.getClassName() != null) {
                serializer.writeAttribute("className", type.getClassName());
            }
            if (type.getDescription() != null) {
                this.writeDescription(type.getDescription(), "description", serializer);
            }
            serializer.writeEndElement();
        }
    }
}

