/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.ConsumerManager;
import org.apache.kafka.server.log.remote.metadata.storage.ProducerManager;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataStore;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerConfig;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicBasedRemoteLogMetadataManager
implements RemoteLogMetadataManager {
    private static final Logger log = LoggerFactory.getLogger(TopicBasedRemoteLogMetadataManager.class);
    private volatile boolean configured = false;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Time time = Time.SYSTEM;
    private final boolean startConsumerThread;
    private Thread initializationThread;
    private volatile ProducerManager producerManager;
    private volatile ConsumerManager consumerManager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private RemotePartitionMetadataStore remotePartitionMetadataStore;
    private volatile TopicBasedRemoteLogMetadataManagerConfig rlmmConfig;
    private volatile RemoteLogMetadataTopicPartitioner rlmTopicPartitioner;
    private final Set<TopicIdPartition> pendingAssignPartitions = Collections.synchronizedSet(new HashSet());
    private volatile boolean initializationFailed;
    private final Supplier<RemotePartitionMetadataStore> remoteLogMetadataManagerSupplier;
    private final Function<Integer, RemoteLogMetadataTopicPartitioner> remoteLogMetadataTopicPartitionerFunction;

    public TopicBasedRemoteLogMetadataManager() {
        this(true, RemoteLogMetadataTopicPartitioner::new, RemotePartitionMetadataStore::new);
    }

    TopicBasedRemoteLogMetadataManager(boolean startConsumerThread, Function<Integer, RemoteLogMetadataTopicPartitioner> remoteLogMetadataTopicPartitionerFunction, Supplier<RemotePartitionMetadataStore> remoteLogMetadataManagerSupplier) {
        this.startConsumerThread = startConsumerThread;
        this.remoteLogMetadataManagerSupplier = remoteLogMetadataManagerSupplier;
        this.remoteLogMetadataTopicPartitionerFunction = remoteLogMetadataTopicPartitionerFunction;
    }

    public CompletableFuture<Void> addRemoteLogSegmentMetadata(RemoteLogSegmentMetadata remoteLogSegmentMetadata) throws RemoteStorageException {
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            if (remoteLogSegmentMetadata.state() != RemoteLogSegmentState.COPY_SEGMENT_STARTED) {
                throw new IllegalArgumentException("Given remoteLogSegmentMetadata should have state as " + RemoteLogSegmentState.COPY_SEGMENT_STARTED + " but it contains state as: " + remoteLogSegmentMetadata.state());
            }
            CompletableFuture<Void> completableFuture = this.storeRemoteLogMetadata(remoteLogSegmentMetadata.remoteLogSegmentId().topicIdPartition(), (RemoteLogMetadata)remoteLogSegmentMetadata);
            return completableFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate segmentMetadataUpdate) throws RemoteStorageException {
        Objects.requireNonNull(segmentMetadataUpdate, "segmentMetadataUpdate can not be null");
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            if (segmentMetadataUpdate.state() == RemoteLogSegmentState.COPY_SEGMENT_STARTED) {
                throw new IllegalArgumentException("Given remoteLogSegmentMetadata should not have the state as: " + RemoteLogSegmentState.COPY_SEGMENT_STARTED);
            }
            CompletableFuture<Void> completableFuture = this.storeRemoteLogMetadata(segmentMetadataUpdate.remoteLogSegmentId().topicIdPartition(), (RemoteLogMetadata)segmentMetadataUpdate);
            return completableFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> putRemotePartitionDeleteMetadata(RemotePartitionDeleteMetadata remotePartitionDeleteMetadata) throws RemoteStorageException {
        Objects.requireNonNull(remotePartitionDeleteMetadata, "remotePartitionDeleteMetadata can not be null");
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            CompletableFuture<Void> completableFuture = this.storeRemoteLogMetadata(remotePartitionDeleteMetadata.topicIdPartition(), (RemoteLogMetadata)remotePartitionDeleteMetadata);
            return completableFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private CompletableFuture<Void> storeRemoteLogMetadata(TopicIdPartition topicIdPartition, RemoteLogMetadata remoteLogMetadata) throws RemoteStorageException {
        log.debug("Storing the partition: {} metadata: {}", (Object)topicIdPartition, (Object)remoteLogMetadata);
        try {
            CompletableFuture<RecordMetadata> produceFuture = this.producerManager.publishMessage(remoteLogMetadata);
            return produceFuture.thenAcceptAsync(recordMetadata -> {
                try {
                    this.consumerManager.waitTillConsumptionCatchesUp((RecordMetadata)recordMetadata);
                }
                catch (TimeoutException e) {
                    throw new KafkaException((Throwable)e);
                }
            });
        }
        catch (KafkaException e) {
            if (e instanceof RetriableException) {
                throw e;
            }
            throw new RemoteStorageException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(TopicIdPartition topicIdPartition, int epochForOffset, long offset) throws RemoteStorageException {
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            Optional<RemoteLogSegmentMetadata> optional = this.remotePartitionMetadataStore.remoteLogSegmentMetadata(topicIdPartition, offset, epochForOffset);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> highestOffsetForEpoch(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            Optional<Long> optional = this.remotePartitionMetadataStore.highestLogOffset(topicIdPartition, leaderEpoch);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            Iterator<RemoteLogSegmentMetadata> iterator = this.remotePartitionMetadataStore.listRemoteLogSegments(topicIdPartition);
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        this.lock.readLock().lock();
        try {
            this.ensureInitializedAndNotClosed();
            Iterator<RemoteLogSegmentMetadata> iterator = this.remotePartitionMetadataStore.listRemoteLogSegments(topicIdPartition, leaderEpoch);
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int metadataPartition(TopicIdPartition topicIdPartition) {
        return this.rlmTopicPartitioner.metadataPartition(topicIdPartition);
    }

    public Optional<Long> readOffsetForPartition(int metadataPartition) {
        return this.consumerManager.readOffsetForPartition(metadataPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartitionLeadershipChanges(Set<TopicIdPartition> leaderPartitions, Set<TopicIdPartition> followerPartitions) {
        Objects.requireNonNull(leaderPartitions, "leaderPartitions can not be null");
        Objects.requireNonNull(followerPartitions, "followerPartitions can not be null");
        log.info("Received leadership notifications with leader partitions {} and follower partitions {}", leaderPartitions, followerPartitions);
        this.lock.readLock().lock();
        try {
            if (this.closing.get()) {
                throw new IllegalStateException("This instance is in closing state");
            }
            HashSet<TopicIdPartition> allPartitions = new HashSet<TopicIdPartition>(leaderPartitions);
            allPartitions.addAll(followerPartitions);
            if (!this.initialized.get()) {
                this.pendingAssignPartitions.addAll(allPartitions);
            } else {
                this.assignPartitions(allPartitions);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void assignPartitions(Set<TopicIdPartition> allPartitions) {
        for (TopicIdPartition partition : allPartitions) {
            this.remotePartitionMetadataStore.maybeLoadPartition(partition);
        }
        this.consumerManager.addAssignmentsForPartitions(allPartitions);
    }

    public void onStopPartitions(Set<TopicIdPartition> partitions) {
        this.lock.readLock().lock();
        try {
            if (this.closing.get()) {
                throw new IllegalStateException("This instance is in closing state");
            }
            if (!this.initialized.get()) {
                if (!this.pendingAssignPartitions.isEmpty()) {
                    this.pendingAssignPartitions.removeAll(partitions);
                }
            } else {
                this.consumerManager.removeAssignmentsForPartitions(partitions);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long remoteLogSize(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        long remoteLogSize = 0L;
        Iterator<RemoteLogSegmentMetadata> remoteLogSegmentMetadataIterator = this.remotePartitionMetadataStore.listRemoteLogSegments(topicIdPartition, leaderEpoch);
        while (remoteLogSegmentMetadataIterator.hasNext()) {
            RemoteLogSegmentMetadata remoteLogSegmentMetadata = remoteLogSegmentMetadataIterator.next();
            remoteLogSize += (long)remoteLogSegmentMetadata.segmentSizeInBytes();
        }
        return remoteLogSize;
    }

    public void configure(Map<String, ?> configs) {
        Objects.requireNonNull(configs, "configs can not be null.");
        this.lock.writeLock().lock();
        try {
            if (this.configured) {
                log.info("Skipping configure as it is already configured.");
                return;
            }
            log.info("Started configuring topic-based RLMM with configs: {}", configs);
            this.rlmmConfig = new TopicBasedRemoteLogMetadataManagerConfig(configs);
            this.rlmTopicPartitioner = this.remoteLogMetadataTopicPartitionerFunction.apply(this.rlmmConfig.metadataTopicPartitionsCount());
            this.remotePartitionMetadataStore = this.remoteLogMetadataManagerSupplier.get();
            this.configured = true;
            log.info("Successfully configured topic-based RLMM with config: {}", (Object)this.rlmmConfig);
            this.initializationThread = KafkaThread.nonDaemon((String)"RLMMInitializationThread", this::initializeResources);
            this.initializationThread.start();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeResources() {
        log.info("Initializing topic-based RLMM resources");
        NewTopic remoteLogMetadataTopicRequest = this.createRemoteLogMetadataTopicRequest();
        boolean topicCreated = false;
        long startTimeMs = this.time.milliseconds();
        Admin adminClient = null;
        try {
            adminClient = Admin.create(this.rlmmConfig.commonProperties());
            while (!this.initialized.get() && !this.closing.get()) {
                block20: {
                    if (this.time.milliseconds() - startTimeMs > this.rlmmConfig.initializationRetryMaxTimeoutMs()) {
                        log.error("Timed out in initializing the resources, retried to initialize the resource for {} ms.", (Object)this.rlmmConfig.initializationRetryMaxTimeoutMs());
                        this.initializationFailed = true;
                        return;
                    }
                    if (!topicCreated) {
                        topicCreated = this.createTopic(adminClient, remoteLogMetadataTopicRequest);
                    }
                    if (!topicCreated) {
                        log.info("Sleep for {} ms before it is retried again.", (Object)this.rlmmConfig.initializationRetryIntervalMs());
                        Utils.sleep((long)this.rlmmConfig.initializationRetryIntervalMs());
                        continue;
                    }
                    try {
                        String topicName = remoteLogMetadataTopicRequest.name();
                        if (this.isPartitionsCountSameAsConfigured(adminClient, topicName)) break block20;
                        this.initializationFailed = true;
                    }
                    catch (Exception e) {
                        log.info("Sleep for {} ms before it is retried again.", (Object)this.rlmmConfig.initializationRetryIntervalMs());
                        Utils.sleep((long)this.rlmmConfig.initializationRetryIntervalMs());
                        continue;
                    }
                }
                this.lock.writeLock().lock();
                try {
                    this.producerManager = new ProducerManager(this.rlmmConfig, this.rlmTopicPartitioner);
                    this.consumerManager = new ConsumerManager(this.rlmmConfig, this.remotePartitionMetadataStore, this.rlmTopicPartitioner, this.time);
                    if (this.startConsumerThread) {
                        this.consumerManager.startConsumerThread();
                    } else {
                        log.info("RLMM Consumer task thread is not configured to be started.");
                    }
                    if (!this.pendingAssignPartitions.isEmpty()) {
                        this.assignPartitions(this.pendingAssignPartitions);
                        this.pendingAssignPartitions.clear();
                    }
                    this.initialized.set(true);
                    log.info("Initialized topic-based RLMM resources successfully");
                    this.lock.writeLock().unlock();
                }
                catch (Exception e) {
                    try {
                        log.error("Encountered error while initializing producer/consumer", (Throwable)e);
                        this.lock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lock.writeLock().unlock();
                            throw throwable;
                        }
                        catch (Exception e2) {
                            log.error("Encountered error while initializing topic-based RLMM resources", (Throwable)e2);
                            this.initializationFailed = true;
                            return;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                            return;
                        }
                    }
                    Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
                    return;
                }
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
        }
    }

    boolean doesTopicExist(Admin adminClient, String topic) {
        try {
            TopicDescription description = (TopicDescription)((KafkaFuture)adminClient.describeTopics(Collections.singleton(topic)).topicNameValues().get(topic)).get();
            if (description != null) {
                log.info("Topic {} exists. TopicId: {}, numPartitions: {}, ", new Object[]{topic, description.topicId(), description.partitions().size()});
            } else {
                log.info("Topic {} does not exist.", (Object)topic);
            }
            return description != null;
        }
        catch (InterruptedException | ExecutionException ex) {
            log.info("Topic {} does not exist. Error: {}", (Object)topic, (Object)ex.getCause().getMessage());
            return false;
        }
    }

    private boolean isPartitionsCountSameAsConfigured(Admin adminClient, String topicName) throws InterruptedException, ExecutionException {
        log.debug("Getting topic details to check for partition count and replication factor.");
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)adminClient.describeTopics(Collections.singleton(topicName)).topicNameValues().get(topicName)).get();
        int expectedPartitions = this.rlmmConfig.metadataTopicPartitionsCount();
        int topicPartitionsSize = topicDescription.partitions().size();
        if (topicPartitionsSize != expectedPartitions) {
            log.error("Existing topic partition count [{}] is not same as the expected partition count [{}]", (Object)topicPartitionsSize, (Object)expectedPartitions);
            return false;
        }
        return true;
    }

    private NewTopic createRemoteLogMetadataTopicRequest() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("retention.ms", Long.toString(this.rlmmConfig.metadataTopicRetentionMs()));
        topicConfigs.put("cleanup.policy", "delete");
        topicConfigs.put("remote.storage.enable", "false");
        return new NewTopic(this.rlmmConfig.remoteLogMetadataTopicName(), this.rlmmConfig.metadataTopicPartitionsCount(), this.rlmmConfig.metadataTopicReplicationFactor()).configs(topicConfigs);
    }

    private boolean createTopic(Admin adminClient, NewTopic newTopic) {
        boolean doesTopicExist = false;
        String topic = newTopic.name();
        try {
            doesTopicExist = this.doesTopicExist(adminClient, topic);
            if (!doesTopicExist) {
                CreateTopicsResult result = adminClient.createTopics(Collections.singleton(newTopic));
                result.all().get();
                List overriddenConfigs = ((Config)result.config(topic).get()).entries().stream().filter(entry -> !entry.isDefault()).map(entry -> entry.name() + "=" + entry.value()).collect(Collectors.toList());
                log.info("Topic {} created. TopicId: {}, numPartitions: {}, replicationFactor: {}, config: {}", new Object[]{topic, result.topicId(topic).get(), result.numPartitions(topic).get(), result.replicationFactor(topic).get(), overriddenConfigs});
                doesTopicExist = true;
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof TopicExistsException) {
                log.info("Topic [{}] already exists", (Object)topic);
                doesTopicExist = true;
            }
            log.error("Encountered error while creating {} topic.", (Object)topic, (Object)e);
        }
        return doesTopicExist;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    private void ensureInitializedAndNotClosed() {
        if (this.initializationFailed) {
            throw new FatalExitError();
        }
        if (this.closing.get() || !this.initialized.get()) {
            throw new IllegalStateException("This instance is in invalid state, initialized: " + this.initialized + " close: " + this.closing);
        }
    }

    public TopicBasedRemoteLogMetadataManagerConfig config() {
        return this.rlmmConfig;
    }

    public void close() throws IOException {
        log.info("Closing topic-based RLMM resources");
        if (this.closing.compareAndSet(false, true)) {
            this.lock.writeLock().lock();
            try {
                if (this.initializationThread != null) {
                    try {
                        this.initializationThread.join();
                    }
                    catch (InterruptedException e) {
                        log.error("Initialization thread was interrupted while waiting to join on close.", (Throwable)e);
                    }
                }
                Utils.closeQuietly((AutoCloseable)this.producerManager, (String)"ProducerTask");
                Utils.closeQuietly((AutoCloseable)this.consumerManager, (String)"RLMMConsumerManager");
                Utils.closeQuietly((AutoCloseable)this.remotePartitionMetadataStore, (String)"RemotePartitionMetadataStore");
            }
            finally {
                this.lock.writeLock().unlock();
                log.info("Closed topic-based RLMM resources");
            }
        }
    }
}

