/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.Stamped;

public class PunctuationSchedule
extends Stamped<ProcessorNode> {
    private final long interval;
    private final Punctuator punctuator;
    private boolean isCancelled = false;
    private final RepointableCancellable cancellable;

    PunctuationSchedule(ProcessorNode node, long time, long interval, Punctuator punctuator) {
        this(node, time, interval, punctuator, new RepointableCancellable());
        this.cancellable.setSchedule(this);
    }

    private PunctuationSchedule(ProcessorNode node, long time, long interval, Punctuator punctuator, RepointableCancellable cancellable) {
        super(node, time);
        this.interval = interval;
        this.punctuator = punctuator;
        this.cancellable = cancellable;
    }

    public ProcessorNode node() {
        return (ProcessorNode)this.value;
    }

    public Punctuator punctuator() {
        return this.punctuator;
    }

    public Cancellable cancellable() {
        return this.cancellable;
    }

    void markCancelled() {
        this.isCancelled = true;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    public PunctuationSchedule next(long currTimestamp) {
        long nextPunctuationTime = this.timestamp + this.interval;
        if (currTimestamp >= nextPunctuationTime) {
            long intervalsMissed = (currTimestamp - this.timestamp) / this.interval;
            nextPunctuationTime = this.timestamp + (intervalsMissed + 1L) * this.interval;
        }
        PunctuationSchedule nextSchedule = new PunctuationSchedule((ProcessorNode)this.value, nextPunctuationTime, this.interval, this.punctuator, this.cancellable);
        this.cancellable.setSchedule(nextSchedule);
        return nextSchedule;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static class RepointableCancellable
    implements Cancellable {
        private PunctuationSchedule schedule;

        private RepointableCancellable() {
        }

        synchronized void setSchedule(PunctuationSchedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public synchronized void cancel() {
            this.schedule.markCancelled();
        }
    }
}

