/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\rv!\u0002\u00180\u0011\u00031d!\u0002\u001d0\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005bBBL\u0003\u0011%1\u0011\u0014\u0005\b\u0007;\u000bA\u0011BBP\r\u0011At\u0006A#\t\u001113!\u0011!Q\u0001\n5C\u0001\u0002\u0015\u0004\u0003\u0002\u0003\u0006I!\u0015\u0005\t=\u001a\u0011\t\u0011)A\u0005?\"AQM\u0002B\u0001B\u0003%a\r\u0003\u0005j\r\t\u0005\t\u0015!\u0003k\u0011!igA!A!\u0002\u0013q\u0007\u0002C;\u0007\u0005\u0003\u0005\u000b\u0011\u0002<\t\u000b\u00013A\u0011A=\u0006\r\u0005\ra\u0001BA\u0003\u000b\u0019\t9B\u0002\u0003\u0002\u001a\u00151\u0011q\u0005\u0004\u0005\u0003S)a!a\u0016\u0007\t\u0005eQABA-\r\u0011\tY\u0006C\u0005\u0002\u0006\u001a\u0011\r\u0011\"\u0003\u0002\b\"A\u0011q\u0014\u0004!\u0002\u0013\tI\tC\u0005\u0002\"\u001a\u0011\r\u0011\"\u0001\u0002$\"9\u0011Q\u0015\u0004!\u0002\u0013\u0011\u0007bBAT\r\u0011\u0005\u0011\u0011\u0016\u0005\n\u0003_4\u0011\u0013!C\u0001\u0003cDqAa\u0002\u0007\t\u0013\u0011I\u0001C\u0004\u0003.\u0019!\tAa\f\t\u0013\tMc!%A\u0005\u0002\tU\u0003b\u0002B-\r\u0011\u0005!1\f\u0005\b\u0005[2A\u0011\u0001B8\u0011\u001d\u0011YJ\u0002C\u0001\u0005;C\u0011B!,\u0007#\u0003%\t!!=\t\u000f\t=f\u0001\"\u0001\u00032\"9!\u0011\u0018\u0004\u0005\u0002\tm\u0006b\u0002Bb\r\u0011%!Q\u0019\u0005\b\u0005W4A\u0011\u0001Bw\u0011%\u0011yPBI\u0001\n\u0003\t\t\u0010C\u0004\u0004\u0002\u0019!Iaa\u0001\t\u000f\rma\u0001\"\u0001\u0004\u001e!91q\u0005\u0004\u0005\u0002\r%\u0002bBB\u0017\r\u0011%1q\u0006\u0005\t\u0007\u00032A\u0011A\u0018\u0004D!911\n\u0004\u0005\u0002\r5\u0003\"CB-\rE\u0005I\u0011AB.\u0011\u001d\u0019yF\u0002C\u0001\u0007C\na\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN\u001d\u0006\u0003aE\n1\u0002\u001e:b]N\f7\r^5p]*\u0011!gM\u0001\fG>|'\u000fZ5oCR|'OC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"aN\u0001\u000e\u0003=\u0012a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\n\u0003\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017\u0003\u0015\t\u0007\u000f\u001d7z)=!51MB7\u0007o\u001aIh! \u0004\f\u000eU\u0005CA\u001c\u0007'\r1!H\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013N\nQ!\u001e;jYNL!a\u0013%\u0003\u000f1{wmZ5oO\u0006IA\u000f\u001f8D_:4\u0017n\u001a\t\u0003o9K!aT\u0018\u0003#Q\u0013\u0018M\\:bGRLwN\\\"p]\u001aLw-A\u0005tG\",G-\u001e7feB\u0011!\u000bX\u0007\u0002'*\u0011A+V\u0001\u0005kRLGN\u0003\u0002W/\u000611/\u001a:wKJT!\u0001\u000e-\u000b\u0005eS\u0016AB1qC\u000eDWMC\u0001\\\u0003\ry'oZ\u0005\u0003;N\u0013\u0011bU2iK\u0012,H.\u001a:\u0002/\r\u0014X-\u0019;f!J|G-^2fe&#W*\u00198bO\u0016\u0014\bcA\u001eaE&\u0011\u0011\r\u0010\u0002\n\rVt7\r^5p]B\u0002\"aN2\n\u0005\u0011|#!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4fe\u0006QA\u000f\u001f8NC:\fw-\u001a:\u0011\u0005]:\u0017B\u000150\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/A\fuq:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011qg[\u0005\u0003Y>\u0012q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003\u0011!\u0018.\\3\u0011\u0005=\u001cX\"\u00019\u000b\u0005%\u000b(B\u0001:X\u0003\u0019\u0019w.\\7p]&\u0011A\u000f\u001d\u0002\u0005)&lW-\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"a\\<\n\u0005a\u0004(A\u0003'pO\u000e{g\u000e^3yiRIAI_>}{z|\u0018\u0011\u0001\u0005\u0006\u0019:\u0001\r!\u0014\u0005\u0006!:\u0001\r!\u0015\u0005\u0006=:\u0001\ra\u0018\u0005\u0006K:\u0001\rA\u001a\u0005\u0006S:\u0001\rA\u001b\u0005\u0006[:\u0001\rA\u001c\u0005\u0006k:\u0001\rA\u001e\u0002\u0017\u0013:LG\u000f\u0015:pIV\u001cWM]%e\u0007\u0006dGNY1dWB91(a\u0002\u0002\f\u0005E\u0011bAA\u0005y\tIa)\u001e8di&|g.\r\t\u0004o\u00055\u0011bAA\b_\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u00042aOA\n\u0013\r\t)\u0002\u0010\u0002\u0005+:LGOA\u000bBI\u0012\u0004\u0016M\u001d;ji&|gn]\"bY2\u0014\u0017mY6\u0011\u000fm\n9!a\u0007\u0002\u0012A!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"E\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003K\tyB\u0001\u0004FeJ|'o\u001d\u0002\u0019-\u0016\u0014\u0018NZ=QCJ$\u0018\u000e^5p]N\u001c\u0015\r\u001c7cC\u000e\\\u0007cB\u001e\u0002\b\u0005-\u0012\u0011\u0003\t\u0005\u0003[\t\tF\u0004\u0003\u00020\u0005-c\u0002BA\u0019\u0003\u000frA!a\r\u0002F9!\u0011QGA\"\u001d\u0011\t9$!\u0011\u000f\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u00106\u0003\u0019a$o\\8u}%\t1,\u0003\u0002Z5&\u0011A\u0007W\u0005\u0003e^K1!!\u0013r\u0003\u001diWm]:bO\u0016LA!!\u0014\u0002P\u0005q\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0004\u0003\u0013\n\u0018\u0002BA*\u0003+\u0012\u0001$\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]J+7/\u001e7u\u0015\u0011\ti%a\u0014\u0003\u001d\u0015sG\r\u0016=o\u0007\u0006dGNY1dW\nI\u0011\t]5SKN,H\u000e^\u000b\u0005\u0003;\n\u0019\b\u0005\u0005\u0002`\u0005%\u00141DA8\u001d\u0011\t\t'!\u001a\u000f\t\u0005e\u00121M\u0005\u0002{%\u0019\u0011q\r\u001f\u0002\u000fA\f7m[1hK&!\u00111NA7\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011q\r\u001f\u0011\t\u0005E\u00141\u000f\u0007\u0001\t\u001d\t)h\u0005b\u0001\u0003o\u0012\u0011\u0001V\t\u0005\u0003s\ny\bE\u0002<\u0003wJ1!! =\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aOAA\u0013\r\t\u0019\t\u0010\u0002\u0004\u0003:L\u0018\u0001C5t\u0003\u000e$\u0018N^3\u0016\u0005\u0005%\u0005\u0003BAF\u00037k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u0007CR|W.[2\u000b\t\u0005M\u0015QS\u0001\u000bG>t7-\u001e:sK:$(b\u0001+\u0002\u0018*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u00065%!D!u_6L7MQ8pY\u0016\fg.A\u0005jg\u0006\u001bG/\u001b<fA\u0005\t\u0002O]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0016\u0003\t\f!\u0003\u001d:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3sA\u0005!\u0002.\u00198eY\u0016Le.\u001b;Qe>$WoY3s\u0013\u0012$B\"!\u0005\u0002,\u0006}\u0016\u0011ZAm\u0003CDq!!,\u0019\u0001\u0004\ty+A\bue\u0006t7/Y2uS>t\u0017\r\\%e!\u0011\t\t,!/\u000f\t\u0005M\u0016Q\u0017\t\u0004\u0003sa\u0014bAA\\y\u00051\u0001K]3eK\u001aLA!a/\u0002>\n11\u000b\u001e:j]\u001eT1!a.=\u0011\u001d\t\t\r\u0007a\u0001\u0003\u0007\fA\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\bcA\u001e\u0002F&\u0019\u0011q\u0019\u001f\u0003\u0007%sG\u000fC\u0004\u0002Lb\u0001\r!!4\u00025\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0011\u000bm\ny-a5\n\u0007\u0005EGH\u0001\u0004PaRLwN\u001c\t\u0004_\u0006U\u0017bAAla\n\u0011\u0002K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i\u0011\u001d\tY\u000e\u0007a\u0001\u0003;\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\u0005}w\"D\u0001\u0007\u0011%\t\u0019\u000f\u0007I\u0001\u0002\u0004\t)/\u0001\u0007sKF,Xm\u001d;M_\u000e\fG\u000e\u0005\u0003\u0002h\u0006-XBAAu\u0015\t16'\u0003\u0003\u0002n\u0006%(\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017A\b5b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\r\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019P\u000b\u0003\u0002f\u0006U8FAA|!\u0011\tIPa\u0001\u000e\u0005\u0005m(\u0002BA\u007f\u0003\u007f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005A(\u0001\u0006b]:|G/\u0019;j_:LAA!\u0002\u0002|\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029A\u0014X\r]1sK&s\u0017\u000e\u001e)s_\u0012,8-\u001a:JIR\u0013\u0018M\\:jiRa!1\u0002B\r\u00057\u0011iB!\t\u0003,A)\u0011q\\\n\u0003\u000eA91Ha\u0004\u0002D\nM\u0011b\u0001B\ty\t1A+\u001e9mKJ\u00022a\u000eB\u000b\u0013\r\u00119b\f\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002.j\u0001\r!a,\t\u000f\u0005\u0005'\u00041\u0001\u0002D\"9!q\u0004\u000eA\u0002\u0005\r\u0017\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\u0011\u0019C\u0007a\u0001\u0005K\t1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCB\u0019qGa\n\n\u0007\t%rFA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002Lj\u0001\r!!4\u0002-!\fg\u000e\u001a7f\u0019&\u001cH\u000f\u0016:b]N\f7\r^5p]N$\u0002B!\r\u0003:\t%#q\n\t\u0005\u0005g\u0011)$\u0004\u0002\u0002P%!!qGA(\u0005qa\u0015n\u001d;Ue\u0006t7/Y2uS>t7OU3ta>t7/\u001a#bi\u0006DqAa\u000f\u001c\u0001\u0004\u0011i$A\ngS2$XM]3e!J|G-^2fe&#7\u000f\u0005\u0004\u00022\n}\"1I\u0005\u0005\u0005\u0003\niLA\u0002TKR\u00042a\u000fB#\u0013\r\u00119\u0005\u0010\u0002\u0005\u0019>tw\rC\u0004\u0003Lm\u0001\rA!\u0014\u0002\u001d\u0019LG\u000e^3sK\u0012\u001cF/\u0019;fgB1\u0011\u0011\u0017B \u0003_C\u0011B!\u0015\u001c!\u0003\u0005\rAa\u0011\u0002!\u0019LG\u000e^3sK\u0012$UO]1uS>t\u0017\u0001\t5b]\u0012dW\rT5tiR\u0013\u0018M\\:bGRLwN\\:%I\u00164\u0017-\u001e7uIM*\"Aa\u0016+\t\t\r\u0013Q_\u0001\u001bQ\u0006tG\r\\3EKN\u001c'/\u001b2f)J\fgn]1di&|gn\u001d\u000b\u0005\u0005;\u0012Y\u0007\u0005\u0003\u0003`\t\u0015d\u0002\u0002B\u001a\u0005CJAAa\u0019\u0002P\u0005\u0001C)Z:de&\u0014W\r\u0016:b]N\f7\r^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u00119G!\u001b\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,'\u0002\u0002B2\u0003\u001fBq!!,\u001e\u0001\u0004\ty+A\u0012iC:$G.\u001a,fe&4\u0017\u0010U1si&$\u0018n\u001c8t\u0013:$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0019\u0005E!\u0011\u000fB:\u0005o\u0012\tIa&\t\u000f\u00055f\u00041\u0001\u00020\"9!Q\u000f\u0010A\u0002\t\r\u0013A\u00039s_\u0012,8-\u001a:JI\"9!\u0011\u0010\u0010A\u0002\tm\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002<\u0005{J1Aa =\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u0011\u0019I\ba\u0001\u0005\u000b\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\u00119I!$\u0003\u00106\u0011!\u0011\u0012\u0006\u0004\u0005\u0017c\u0014AC2pY2,7\r^5p]&!!\u0011\tBE!\u0011\u0011\tJa%\u000e\u0003EL1A!&r\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a7\u001f\u0001\u0004\u0011I\nE\u0002\u0002`F\t\u0001\u0005[1oI2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]Rq\u0011\u0011\u0003BP\u0005C\u0013\u0019K!*\u0003(\n-\u0006bBAW?\u0001\u0007\u0011q\u0016\u0005\b\u0005kz\u0002\u0019\u0001B\"\u0011\u001d\u0011Ih\ba\u0001\u0005wBqAa! \u0001\u0004\u0011)\tC\u0004\u0002\\~\u0001\rA!+\u0011\u0007\u0005}\u0007\u0003C\u0005\u0002d~\u0001\n\u00111\u0001\u0002f\u0006Q\u0003.\u00198eY\u0016\fE\r\u001a)beRLG/[8ogR{GK]1og\u0006\u001cG/[8oI\u0011,g-Y;mi\u00122\u0014AC8o\u000b2,7\r^5p]R1\u0011\u0011\u0003BZ\u0005oCqA!.\"\u0001\u0004\t\u0019-A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0003 \u0005\u0002\r!a1\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\t\tB!0\u0003@\"9!Q\u0017\u0012A\u0002\u0005\r\u0007b\u0002B\u0010E\u0001\u0007!\u0011\u0019\t\u0006w\u0005=\u00171Y\u0001(Y><\u0017J\u001c<bY&$7\u000b^1uKR\u0013\u0018M\\:ji&|g.\u00118e%\u0016$XO\u001d8FeJ|'\u000f\u0006\u0005\u0003H\nE'1\u001bBn!!\u0011IM!4\u0002\u001c\u0005eTB\u0001Bf\u0015\t!F(\u0003\u0003\u0003P\n-'\u0001\u0002'fMRDq!!,$\u0001\u0004\ty\u000bC\u0004\u0003V\u000e\u0002\rAa6\u0002!Q\u0014\u0018M\\:bGRLwN\\*uCR,\u0007cA\u001c\u0003Z&\u0019!qM\u0018\t\u000f\tu7\u00051\u0001\u0003`\u0006\tBO]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\t\t\u0005(q]\u0007\u0003\u0005GT1A!:r\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002Bu\u0005G\u0014\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0003QA\u0017M\u001c3mK\u0016sG\r\u0016:b]N\f7\r^5p]Rq\u0011\u0011\u0003Bx\u0005c\u0014\u0019P!>\u0003z\nu\bbBAWI\u0001\u0007\u0011q\u0016\u0005\b\u0005k\"\u0003\u0019\u0001B\"\u0011\u001d\u0011I\b\na\u0001\u0005wBqAa>%\u0001\u0004\u0011y.A\buq:l\u0015M]6feJ+7/\u001e7u\u0011\u001d\tY\u000e\na\u0001\u0005w\u00042!a8\u0013\u0011%\t\u0019\u000f\nI\u0001\u0002\u0004\t)/\u0001\u0010iC:$G.Z#oIR\u0013\u0018M\\:bGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%m\u0005qQM\u001c3Ue\u0006t7/Y2uS>tG\u0003EA\t\u0007\u000b\u00199a!\u0003\u0004\f\r51qCB\r\u0011\u001d\tiK\na\u0001\u0003_CqA!\u001e'\u0001\u0004\u0011\u0019\u0005C\u0004\u0003z\u0019\u0002\rAa\u001f\t\u000f\t]h\u00051\u0001\u0003`\"91q\u0002\u0014A\u0002\rE\u0011\u0001D5t\rJ|Wn\u00117jK:$\bcA\u001e\u0004\u0014%\u00191Q\u0003\u001f\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u001c\u0014A\u0002\tm\bbBArM\u0001\u0007\u0011Q]\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"aa\b\u0011\t\r\u000521E\u0007\u0003\u0003+KAa!\n\u0002\u0016\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\t\u0005\r71\u0006\u0005\b\u0003[C\u0003\u0019AAX\u0003ayg.\u00128e)J\fgn]1di&|gnQ8na2,G/\u001a\u000b\u0005\u0007c\u00199\u0004\u0006\u0003\u0002\u0012\rM\u0002bBB\u001bS\u0001\u0007\u00111D\u0001\u0006KJ\u0014xN\u001d\u0005\b\u0007sI\u0003\u0019AB\u001e\u0003A!\bP\\%e\u0003:$\u0007+\u001b3Fa>\u001c\u0007\u000eE\u00028\u0007{I1aa\u00100\u0005\u0005\"&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017I\u001c3Qe>$WoY3s\u0013\u0012,\u0005o\\2i\u0003e\t'm\u001c:u)&lW\rZ(viR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005E1Q\t\u0005\b\u0007\u000fR\u0003\u0019AB%\u0003)ygnQ8na2,G/\u001a\t\bw\u0005\u001d11\bB~\u0003\u001d\u0019H/\u0019:ukB$b!!\u0005\u0004P\rU\u0003bBB)W\u0001\u000711K\u0001'e\u0016$(/[3wKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\b\u0003B\u001ea\u0003\u0007D\u0011ba\u0016,!\u0003\u0005\ra!\u0005\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.A\tti\u0006\u0014H/\u001e9%I\u00164\u0017-\u001e7uII*\"a!\u0018+\t\rE\u0011Q_\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011\u0003\u0005\b\u0007K\u001a\u0001\u0019AB4\u0003\u0019\u0019wN\u001c4jOB!\u0011q]B5\u0013\u0011\u0019Y'!;\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0007_\u001a\u0001\u0019AB9\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!a:\u0004t%!1QOAu\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQ\u0001U\u0002A\u0002ECaaa\u001f\u0004\u0001\u0004y\u0016!G2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u000f\u0016tWM]1u_JDqaa \u0004\u0001\u0004\u0019\t)A\u0004nKR\u0014\u0018nY:\u0011\t\r\r5qQ\u0007\u0003\u0007\u000bS1aa r\u0013\u0011\u0019Ii!\"\u0003\u000f5+GO]5dg\"91QR\u0002A\u0002\r=\u0015!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0003\u0002h\u000eE\u0015\u0002BBJ\u0003S\u0014Q\"T3uC\u0012\fG/Y\"bG\",\u0007\"B7\u0004\u0001\u0004q\u0017\u0001F5oSR$&/\u00198tC\u000e$\u0018n\u001c8FeJ|'\u000f\u0006\u0003\u0002\f\rm\u0005bBB\u001b\t\u0001\u0007\u00111D\u0001\u0018S:LG\u000f\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$B!a\u0003\u0004\"\"9!1E\u0003A\u0002\tM\u0001")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> function0, Metrics metrics, MetadataCache metadataCache, Time time) {
        if (TransactionCoordinator$.MODULE$ == null) {
            throw null;
        }
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(kafkaConfig.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicPartitions()), Predef$.MODULE$.Short2short(kafkaConfig.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicMinISR()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.requestTimeoutMs()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(kafkaConfig.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(kafkaConfig.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(apply_txnConfig, scheduler, function0, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            Try<Object> try_ = this.producerIdManager().generateProducerId();
            if (try_ instanceof Success) {
                long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.forException((Throwable)exception)));
                return;
            }
            throw new MatchError(try_);
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                Try<Object> try_ = this.producerIdManager().generateProducerId();
                if (try_ instanceof Success) {
                    long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                    long x$3 = -1L;
                    short x$4 = -1;
                    short x$5 = -1;
                    Empty$ x$7 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$8 = scala.collection.mutable.Set$.MODULE$.empty();
                    long x$9 = $this.time.milliseconds();
                    long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
                    TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, x$3, x$4, x$5, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                    return $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
                }
                if (try_ instanceof Failure) {
                    Throwable exception = ((Failure)try_).exception();
                    return package$.MODULE$.Left().apply((Object)Errors.forException((Throwable)exception));
                }
                throw new MatchError(try_);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                return package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            }
            throw new MatchError(x0$1);
        }).flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_2 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable & scala.Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleInitProducerId$default$5() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        if (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState)) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState))) {
            Left transitMetadataResult;
            Left left;
            if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$1)))) {
                Try<Object> try_ = this.producerIdManager().generateProducerId();
                if (try_ instanceof Success) {
                    long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                    left = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(producerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError(try_);
                    Throwable exception = ((Failure)try_).exception();
                    left = package$.MODULE$.Left().apply((Object)Errors.forException((Throwable)exception));
                }
            } else {
                left = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)x$2.epoch)), this.time.milliseconds());
            }
            if (transitMetadataResult instanceof Right) {
                TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
            }
            if (!(transitMetadataResult instanceof Left)) throw new MatchError(transitMetadataResult);
            Errors err = (Errors)((Left)transitMetadataResult).value();
            return package$.MODULE$.Left().apply((Object)err);
        }
        if (Ongoing$.MODULE$.equals(transactionState)) {
            return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
        }
        if (!(Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState))) throw new MatchError((Object)transactionState);
        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
        throw new IllegalStateException(errorMsg);
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates, long filteredDuration) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates, filteredDuration);
    }

    public long handleListTransactions$default$3() {
        return -1L;
    }

    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        Option option;
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Errors error = (Errors)((Left)either).value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                TransactionState transactionState = txnMetadata.state();
                Dead$ dead$ = Dead$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(dead$) : dead$ != null)) {
                    return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
                }
                txnMetadata.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
                return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().name()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
            });
        }
        throw new MatchError(either);
    }

    public void handleVerifyPartitionsInTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<AddPartitionsToTxnResponseData.AddPartitionsToTxnResult, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)Errors.INVALID_REQUEST), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block6: {
                        block5: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block5;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block6;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    return package$.MODULE$.Right().apply((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)part -> {
                        if (txnMetadata.topicPartitions().contains(part)) {
                            return new Tuple2(part, (Object)Errors.NONE);
                        }
                        return new Tuple2(part, (Object)Errors.TRANSACTION_ABORTABLE);
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                });
            }
            throw new MatchError(x0$1);
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)err), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())));
            return;
        }
        if (result instanceof Right) {
            scala.collection.immutable.Map errors = (scala.collection.immutable.Map)((Right)result).value();
            BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)errors).asJava())));
            return;
        }
        throw new MatchError((Object)result);
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            }
            throw new MatchError(x0$1);
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    }
                    if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Empty$.MODULE$.equals(transactionState)) {
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                });
            }
            throw new MatchError(x0$1);
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable endTransaction_x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    if (Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)))) {
                                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    }
                                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                            return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                        }
                                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    }
                                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                            return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                        }
                                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    }
                                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                });
                            }
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                            return package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                        }
                        throw new MatchError(x0$1);
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public RequestLocal handleEndTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    }
                    if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Empty$.MODULE$.equals(transactionState)) {
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                });
            }
            throw new MatchError(x0$1);
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    if (Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)))) {
                                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    }
                                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                            return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                        }
                                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    }
                                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                            return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                        }
                                        return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    }
                                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                });
                            }
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                            return package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                        }
                        throw new MatchError(x0$1);
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        if (Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error))) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
                } else if (x0$1 instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                    ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError(x0$1);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", () -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs(), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData);
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$5).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$5).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            if (Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)))) {
                                return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                }
                                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                }
                                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                                String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError((Object)transactionState);
                        });
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                    return package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                }
                throw new MatchError(x0$1);
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$5).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            if (Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)))) {
                                return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                }
                                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                }
                                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                                String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError((Object)transactionState);
                        });
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                    return package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                }
                throw new MatchError(x0$1);
            });
            if (sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)sendTxnMarkersCallback$1_preSendResult).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (sendTxnMarkersCallback$1_preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)sendTxnMarkersCallback$1_preSendResult).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)sendTxnMarkersCallback$1_preSendResult);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            $this.txnManager.getTransactionState(transactionalId$5).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$8, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$8.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), RequestLocal$.MODULE$.NoCaching());
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            } else if (x0$1 instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = (ProducerIdManager)createProducerIdManager.apply();
    }
}

