/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.util.FutureUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=v!\u0002\u0013&\u0011\u0003ac!\u0002\u0018&\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0003Id!\u0002\u0018&\u0001\u0015Z\u0004\u0002\u0003\u0015\u0005\u0005\u000b\u0007I\u0011B(\t\u0011I#!\u0011!Q\u0001\nAC\u0001b\u0015\u0003\u0003\u0006\u0004%I\u0001\u0016\u0005\t;\u0012\u0011\t\u0011)A\u0005+\")a\u0007\u0002C\u0001=\")\u0011\r\u0002C!E\")a\u0010\u0002C!\u007f\"9\u0011Q\u0004\u0003\u0005B\u0005}\u0001bBA\u001b\t\u0011\u0005\u0013q\u0007\u0005\b\u0003\u0017\"A\u0011IA'\u0011\u001d\t\t\u0007\u0002C!\u0003GBq!a\u001e\u0005\t\u0003\nI\bC\u0004\u00022\u0012!\t%a-\t\u000f\u0005-G\u0001\"\u0011\u0002N\"9\u00111 \u0003\u0005B\u0005u\bb\u0002B\u0003\t\u0011%!q\u0001\u0005\b\u0005g!A\u0011\tB\u001b\u0011\u001d\u0011Y\u0005\u0002C!\u0005\u001bBqAa\u0019\u0005\t\u0013\u0011)\u0007C\u0004\u0003\u0018\u0012!\tE!'\t\u000f\t=F\u0001\"\u0011\u00032\"9!\u0011\u001e\u0003\u0005B\t-\bb\u0002Bx\t\u0011\u0005#\u0011\u001f\u0005\b\u0007\u000f!A\u0011IB\u0005\u0011\u001d\u0019\u0019\u0002\u0002C!\u0007+Aqaa\b\u0005\t\u0003\u001a\t\u0003C\u0004\u0004.\u0011!\tea\f\t\u000f\r-C\u0001\"\u0011\u0004N!91Q\u000b\u0003\u0005B\r]\u0003bBB5\t\u0011\u000531\u000e\u0005\b\u0007[\"A\u0011IB8\u0003]9%o\\;q\u0007>|'\u000fZ5oCR|'/\u00113baR,'O\u0003\u0002'O\u0005)qM]8va*\u0011\u0001&K\u0001\fG>|'\u000fZ5oCR|'OC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!L\u0001\u000e\u0003\u0015\u0012qc\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:BI\u0006\u0004H/\u001a:\u0014\u0005\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002Y\u0005)\u0011\r\u001d9msRI!h!\"\u0004\u0016\u000e}5\u0011\u0015\t\u0003[\u0011\u00192\u0001\u0002\u001fE!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u00142kK\u000e$\bCA#N\u001b\u00051%B\u0001\u0014H\u0015\tA\u0003J\u0003\u0002+\u0013*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h\u0013\tqeI\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;peV\t\u0001\u000b\u0005\u0002.#&\u0011a*J\u0001\rG>|'\u000fZ5oCR|'\u000fI\u0001\u0005i&lW-F\u0001V!\t16,D\u0001X\u0015\tA\u0016,A\u0003vi&d7O\u0003\u0002[\u0011\u000611m\\7n_:L!\u0001X,\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u0004u}\u0003\u0007\"\u0002\u0015\n\u0001\u0004\u0001\u0006\"B*\n\u0001\u0004)\u0016AF2p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;\u0015\u0007\r\f\u0018\u0010E\u0002eS.l\u0011!\u001a\u0006\u0003M\u001e\f!bY8oGV\u0014(/\u001a8u\u0015\tA\u0007)\u0001\u0003vi&d\u0017B\u00016f\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0003Y>l\u0011!\u001c\u0006\u0003]f\u000bq!\\3tg\u0006<W-\u0003\u0002q[\n\u00113i\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fGOU3ta>t7/\u001a#bi\u0006DQA\u001d\u0006A\u0002M\fqaY8oi\u0016DH\u000f\u0005\u0002uo6\tQO\u0003\u0002w3\u0006A!/Z9vKN$8/\u0003\u0002yk\nq!+Z9vKN$8i\u001c8uKb$\b\"\u0002>\u000b\u0001\u0004Y\u0018a\u0002:fcV,7\u000f\u001e\t\u0003YrL!!`7\u0003C\r{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR\u0014V-];fgR$\u0015\r^1\u0002\u0013)|\u0017N\\$s_V\u0004H\u0003CA\u0001\u0003\u0013\tY!a\u0005\u0011\t\u0011L\u00171\u0001\t\u0004Y\u0006\u0015\u0011bAA\u0004[\n)\"j\\5o\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007\"\u0002:\f\u0001\u0004\u0019\bB\u0002>\f\u0001\u0004\ti\u0001E\u0002m\u0003\u001fI1!!\u0005n\u0005QQu.\u001b8He>,\bOU3rk\u0016\u001cH\u000fR1uC\"9\u0011QC\u0006A\u0002\u0005]\u0011A\u00042vM\u001a,'oU;qa2LWM\u001d\t\u0004-\u0006e\u0011bAA\u000e/\nq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018!C:z]\u000e<%o\\;q)!\t\t#!\u000b\u0002,\u0005M\u0002\u0003\u00023j\u0003G\u00012\u0001\\A\u0013\u0013\r\t9#\u001c\u0002\u0016'ft7m\u0012:pkB\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015\u0011H\u00021\u0001t\u0011\u0019QH\u00021\u0001\u0002.A\u0019A.a\f\n\u0007\u0005ERN\u0001\u000bTs:\u001cwI]8vaJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003+a\u0001\u0019AA\f\u0003%AW-\u0019:uE\u0016\fG\u000f\u0006\u0004\u0002:\u0005\u0005\u00131\t\t\u0005I&\fY\u0004E\u0002m\u0003{I1!a\u0010n\u0005UAU-\u0019:uE\u0016\fGOU3ta>t7/\u001a#bi\u0006DQA]\u0007A\u0002MDaA_\u0007A\u0002\u0005\u0015\u0003c\u00017\u0002H%\u0019\u0011\u0011J7\u0003)!+\u0017M\u001d;cK\u0006$(+Z9vKN$H)\u0019;b\u0003)aW-\u0019<f\u000fJ|W\u000f\u001d\u000b\u0007\u0003\u001f\n9&!\u0017\u0011\t\u0011L\u0017\u0011\u000b\t\u0004Y\u0006M\u0013bAA+[\n1B*Z1wK\u001e\u0013x.\u001e9SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003s\u001d\u0001\u00071\u000f\u0003\u0004{\u001d\u0001\u0007\u00111\f\t\u0004Y\u0006u\u0013bAA0[\n)B*Z1wK\u001e\u0013x.\u001e9SKF,Xm\u001d;ECR\f\u0017A\u00037jgR<%o\\;qgR1\u0011QMA7\u0003_\u0002B\u0001Z5\u0002hA\u0019A.!\u001b\n\u0007\u0005-TN\u0001\fMSN$xI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015\u0011x\u00021\u0001t\u0011\u0019Qx\u00021\u0001\u0002rA\u0019A.a\u001d\n\u0007\u0005UTNA\u000bMSN$xI]8vaN\u0014V-];fgR$\u0015\r^1\u0002\u001d\u0011,7o\u0019:jE\u0016<%o\\;qgR1\u00111PAJ\u0003+\u0003B\u0001Z5\u0002~A1\u0011qPAA\u0003\u000bk\u0011aZ\u0005\u0004\u0003\u0007;'\u0001\u0002'jgR\u0004B!a\"\u0002\u000e:\u0019A.!#\n\u0007\u0005-U.\u0001\u000eEKN\u001c'/\u001b2f\u000fJ|W\u000f]:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002\u0010\u0006E%A\u0004#fg\u000e\u0014\u0018NY3e\u000fJ|W\u000f\u001d\u0006\u0004\u0003\u0017k\u0007\"\u0002:\u0011\u0001\u0004\u0019\bbBAL!\u0001\u0007\u0011\u0011T\u0001\tOJ|W\u000f]%egB1\u0011qPAA\u00037\u0003B!!(\u0002,:!\u0011qTAT!\r\t\tKM\u0007\u0003\u0003GS1!!*,\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0016\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti+a,\u0003\rM#(/\u001b8h\u0015\r\tIKM\u0001\rI\u0016dW\r^3He>,\bo\u001d\u000b\t\u0003k\u000b)-a2\u0002JB!A-[A\\!\u0011\tI,a0\u000f\u00071\fY,C\u0002\u0002>6\f\u0001\u0004R3mKR,wI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\t\t-a1\u0003=\u0011+G.\u001a;bE2,wI]8vaJ+7/\u001e7u\u0007>dG.Z2uS>t'bAA_[\")!/\u0005a\u0001g\"9\u0011qS\tA\u0002\u0005e\u0005bBA\u000b#\u0001\u0007\u0011qC\u0001\u0010M\u0016$8\r[!mY>3gm]3ugRA\u0011qZAp\u0003C\f\t\u0010\u0005\u0003eS\u0006E\u0007\u0003BAj\u00033t1\u0001\\Ak\u0013\r\t9.\\\u0001\u0018\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LA!a7\u0002^\nArJ\u001a4tKR4U\r^2i%\u0016\u001c\bo\u001c8tK\u001e\u0013x.\u001e9\u000b\u0007\u0005]W\u000eC\u0003s%\u0001\u00071\u000f\u0003\u0004{%\u0001\u0007\u00111\u001d\t\u0005\u0003K\fYOD\u0002m\u0003OL1!!;n\u0003YyeMZ:fi\u001a+Go\u00195SKF,Xm\u001d;ECR\f\u0017\u0002BAw\u0003_\u0014qc\u00144gg\u0016$h)\u001a;dQJ+\u0017/^3ti\u001e\u0013x.\u001e9\u000b\u0007\u0005%X\u000eC\u0004\u0002tJ\u0001\r!!>\u0002\u001bI,\u0017/^5sKN#\u0018M\u00197f!\r\t\u0014q_\u0005\u0004\u0003s\u0014$a\u0002\"p_2,\u0017M\\\u0001\rM\u0016$8\r[(gMN,Go\u001d\u000b\t\u0003\u001f\fyP!\u0001\u0003\u0004!)!o\u0005a\u0001g\"1!p\u0005a\u0001\u0003GDq!a=\u0014\u0001\u0004\t)0A\tiC:$G.\u001a$fi\u000eDwJ\u001a4tKR$\u0002\"a4\u0003\n\t5!q\u0002\u0005\b\u0005\u0017!\u0002\u0019AAN\u0003\u001d9'o\\;q\u0013\u0012Dq!a=\u0015\u0001\u0004\t)\u0010C\u0004\u0003\u0012Q\u0001\rAa\u0005\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u00032\u0005+\u0011I\"C\u0002\u0003\u0018I\u0012aa\u00149uS>t\u0007C\u0002B\u000e\u0005K\u0011YC\u0004\u0003\u0003\u001e\t\u0005b\u0002BAQ\u0005?I\u0011aM\u0005\u0004\u0005G\u0011\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0011ICA\u0002TKFT1Aa\t3!\u0011\u0011iCa\f\u000e\u0003eK1A!\rZ\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQbY8n[&$xJ\u001a4tKR\u001cH\u0003\u0003B\u001c\u0005\u007f\u0011\tE!\u0013\u0011\t\u0011L'\u0011\b\t\u0004Y\nm\u0012b\u0001B\u001f[\nArJ\u001a4tKR\u001cu.\\7jiJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bI,\u0002\u0019A:\t\ri,\u0002\u0019\u0001B\"!\ra'QI\u0005\u0004\u0005\u000fj'aF(gMN,GoQ8n[&$(+Z9vKN$H)\u0019;b\u0011\u001d\t)\"\u0006a\u0001\u0003/\t!dY8n[&$HK]1og\u0006\u001cG/[8oC2|eMZ:fiN$\u0002Ba\u0014\u0003X\te#\u0011\r\t\u0005I&\u0014\t\u0006E\u0002m\u0005'J1A!\u0016n\u0005m!\u0006P\\(gMN,GoQ8n[&$(+Z:q_:\u001cX\rR1uC\")!O\u0006a\u0001g\"1!P\u0006a\u0001\u00057\u00022\u0001\u001cB/\u0013\r\u0011y&\u001c\u0002\u001b)btwJ\u001a4tKR\u001cu.\\7jiJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003+1\u0002\u0019AA\f\u0003]\u0019'/Z1uK>3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\r\u0006\b\u0003h\tE$1\u0010B@\u0005\u0013\u0013iI!%\u0011\t\t%$QN\u0007\u0003\u0005WR!AW\u0015\n\t\t=$1\u000e\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007b\u0002B:/\u0001\u0007!QO\u0001\u000eGV\u0014(/\u001a8u)&lW-T:\u0011\u0007E\u00129(C\u0002\u0003zI\u0012A\u0001T8oO\"9!QP\fA\u0002\tU\u0014AB8gMN,G\u000fC\u0004\u0003\u0002^\u0001\rAa!\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0004c\t\u0015\u0015b\u0001BDe\t\u0019\u0011J\u001c;\t\u000f\t-u\u00031\u0001\u0002\u001c\u0006AQ.\u001a;bI\u0006$\u0018\rC\u0004\u0003\u0010^\u0001\rA!\u001e\u0002\u001f\r|W.\\5u)&lWm\u001d;b[BDqAa%\u0018\u0001\u0004\u0011)*A\bfqBL'/\u001a+j[\u0016\u001cH/Y7q!\u0015\t$Q\u0003B;\u00035!W\r\\3uK>3gm]3ugRA!1\u0014BR\u0005K\u0013i\u000b\u0005\u0003eS\nu\u0005c\u00017\u0003 &\u0019!\u0011U7\u00031=3gm]3u\t\u0016dW\r^3SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003s1\u0001\u00071\u000f\u0003\u0004{1\u0001\u0007!q\u0015\t\u0004Y\n%\u0016b\u0001BV[\n9rJ\u001a4tKR$U\r\\3uKJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003+A\u0002\u0019AA\f\u0003M\u0019w.\u001c9mKR,GK]1og\u0006\u001cG/[8o)9\u0011\u0019La/\u0003@\n\r'Q\u001aBi\u00057\u0004B\u0001Z5\u00036B\u0019QHa.\n\u0007\tefH\u0001\u0003W_&$\u0007b\u0002B_3\u0001\u0007!1F\u0001\u0003iBDqA!1\u001a\u0001\u0004\u0011)(\u0001\u0006qe>$WoY3s\u0013\u0012DqA!2\u001a\u0001\u0004\u00119-A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004c\t%\u0017b\u0001Bfe\t)1\u000b[8si\"9!qZ\rA\u0002\t\r\u0015\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\u0011\u0019.\u0007a\u0001\u0005+\faA]3tk2$\bc\u0001;\u0003X&\u0019!\u0011\\;\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fC\u0004\u0003^f\u0001\rAa8\u0002\u000fQLW.Z8viB!!\u0011\u001dBs\u001b\t\u0011\u0019O\u0003\u0002T\u0001&!!q\u001dBr\u0005!!UO]1uS>t\u0017\u0001\u00049beRLG/[8o\r>\u0014H\u0003\u0002BB\u0005[DqAa\u0003\u001b\u0001\u0004\tY*\u0001\fp]R\u0013\u0018M\\:bGRLwN\\\"p[BdW\r^3e)!\u0011\u0019P!?\u0003|\u000e\r\u0001cA\u0019\u0003v&\u0019!q\u001f\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0003\\\u0002\u0019\u0001B;\u0011\u001d\u0011\tb\u0007a\u0001\u0005{\u0004R!\u0010B\u0000\u0005WI1a!\u0001?\u0005!IE/\u001a:bE2,\u0007bBB\u00037\u0001\u0007!Q[\u0001\u0012iJ\fgn]1di&|gNU3tk2$\u0018aE8o!\u0006\u0014H/\u001b;j_:\u001cH)\u001a7fi\u0016$GC\u0002Bz\u0007\u0017\u0019\t\u0002C\u0004\u0004\u000eq\u0001\raa\u0004\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004b!a \u0002\u0002\n-\u0002bBA\u000b9\u0001\u0007\u0011qC\u0001\u000b_:,E.Z2uS>tGC\u0002Bz\u0007/\u0019Y\u0002C\u0004\u0004\u001au\u0001\rAa!\u00027\u001d\u0014x.\u001e9NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:Le\u000eZ3y\u0011\u001d\u0019i\"\ba\u0001\u0005\u0007\u000b\u0011e\u001a:pkBlU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\fQb\u001c8SKNLwM\\1uS>tGC\u0002Bz\u0007G\u0019)\u0003C\u0004\u0004\u001ay\u0001\rAa!\t\u000f\rua\u00041\u0001\u0004(A!\u0011qPB\u0015\u0013\r\u0019Yc\u001a\u0002\f\u001fB$\u0018n\u001c8bY&sG/\u0001\np]:+w/T3uC\u0012\fG/Y%nC\u001e,GC\u0002Bz\u0007c\u0019\t\u0005C\u0004\u00044}\u0001\ra!\u000e\u0002\u00119,w/S7bO\u0016\u0004Baa\u000e\u0004>5\u00111\u0011\b\u0006\u0004\u0007wA\u0015!B5nC\u001e,\u0017\u0002BB \u0007s\u0011Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007bBB\"?\u0001\u00071QI\u0001\u0006I\u0016dG/\u0019\t\u0005\u0007o\u00199%\u0003\u0003\u0004J\re\"!D'fi\u0006$\u0017\r^1EK2$\u0018-A\rhe>,\b/T3uC\u0012\fG/\u0019+pa&\u001c7i\u001c8gS\u001e\u001cHCAB(!\u0011\tyh!\u0015\n\u0007\rMsM\u0001\u0006Qe>\u0004XM\u001d;jKN\fqa\u001d;beR,\b\u000f\u0006\u0003\u0003t\u000ee\u0003bBB.C\u0001\u00071QL\u0001!OJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000f\u0005\u0003\u0004`\r\u0015TBAB1\u0015\r\u0019\u0019gZ\u0001\tMVt7\r^5p]&!1qMB1\u0005-Ie\u000e^*vaBd\u0017.\u001a:\u0002\u0011MDW\u000f\u001e3po:$\"Aa=\u0002+\r|gn];nKJ<%o\\;q\t\u0016\u001c8M]5cKR11\u0011OBA\u0007\u0007\u0003B\u0001Z5\u0004tA1\u0011qPAA\u0007k\u0002Baa\u001e\u0004~9\u0019An!\u001f\n\u0007\rmT.A\u0011D_:\u001cX/\\3s\u000fJ|W\u000f\u001d#fg\u000e\u0014\u0018NY3SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002\u0010\u000e}$bAB>[\")!o\ta\u0001g\"9\u0011qS\u0012A\u0002\u0005e\u0005bBBD\u0007\u0001\u00071\u0011R\u0001\u0007G>tg-[4\u0011\t\r-5\u0011S\u0007\u0003\u0007\u001bS1aa$*\u0003\u0019\u0019XM\u001d<fe&!11SBG\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\r]5\u00011\u0001\u0004\u001a\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BBF\u00077KAa!(\u0004\u000e\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"B*\u0004\u0001\u0004)\u0006bBBR\u0007\u0001\u00071QU\u0001\b[\u0016$(/[2t!\u0011\u00199ka+\u000e\u0005\r%&bABR3&!1QVBU\u0005\u001diU\r\u001e:jGN\u0004")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(kafkaConfig, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_HEARTBEAT.name).append(" API.").toString()));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(request.protocols().valuesList()).asScala()).map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()), Buffer$.MODULE$.canBuildFrom())).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.members()).asScala()).toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())), (Set<String>)((Set)Option$.MODULE$.apply((Object)request.typesFilter()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        void error2 = var4_4;
        void groups2 = var5_5;
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(error2.code());
        groups2.foreach((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$5(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(groupIds).asScala()).map((Function1 & Serializable & scala.Serializable)groupId -> this.describeGroup$1((String)groupId), Buffer$.MODULE$.canBuildFrom())).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code())));
        Map<String, Errors> map = Implicits$.MODULE$.MapExtensionMethods(this.coordinator().handleDeleteGroups((Set<String>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(groupIds).asScala()).toSet(), new RequestLocal(bufferSupplier)));
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        request.topics().forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> handleFetchOffset(String groupId, boolean requireStable, Option<Seq<TopicPartition>> partitions) {
        void var6_6;
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        void error2 = var5_5;
        void results2 = var6_6;
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> future = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        void v0 = error2;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)error2.exception());
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset));
            Map map = Implicits$.MODULE$.MapExtensionMethods(results2);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            future.complete(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(topicsList));
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationIdOrMemberEpoch(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap(Predef$.MODULE$.$conforms()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), -1L, (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.transactionalId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap(Predef$.MODULE$.$conforms()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier), context.apiVersion());
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, long commitTimestamp, Option<Object> expireTimestamp) {
        Optional<Integer> optional;
        switch (leaderEpoch) {
            case -1: {
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            }
        }
        return new OffsetAndMetadata(offset, optional, metadata == null ? OffsetAndMetadata$.MODULE$.NoMetadata() : metadata, -1L == commitTimestamp ? currentTimeMs : commitTimestamp, expireTimestamp);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var8_8;
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void groupError2 = var7_7;
        void topicPartitionResults2 = var8_8;
        void v0 = groupError2;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)groupError2.exception());
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error));
            Map map = Implicits$.MODULE$.MapExtensionMethods(topicPartitionResults2);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        return FutureUtils.failedFuture((Throwable)new IllegalStateException("The old group coordinator does not support `completeTransaction` API."));
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public void onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(partitions).asScala()), transactionResult);
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPartitions).asScala()), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    public CompletableFuture<java.util.List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception(new StringBuilder(48).append("The old group coordinator does not support ").append(ApiKeys.CONSUMER_GROUP_DESCRIBE.name).append(" API.").toString()));
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)joinResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)syncGroupResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable & scala.Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull(Predef$.MODULE$.$conforms())), List$.MODULE$.canBuildFrom())).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$5(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()).setGroupType(group.groupType()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId) {
        void var4_4;
        void var3_3;
        Tuple2<Errors, GroupSummary> tuple2 = this.coordinator().handleDescribeGroup(groupId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        GroupSummary summary = (GroupSummary)tuple2._2();
        void error2 = var3_3;
        void summary2 = var4_4;
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(error2.code()).setGroupId(groupId).setGroupState(summary2.state()).setProtocolType(summary2.protocolType()).setProtocolData(summary2.protocol()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)summary2.members().map((Function1 & Serializable & scala.Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull(Predef$.MODULE$.$conforms())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()), List$.MODULE$.canBuildFrom())).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error));
        Map map = Implicits$.MODULE$.MapExtensionMethods(commitStatus);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), partition.commitTimestamp(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error));
        Map map = Implicits$.MODULE$.MapExtensionMethods(results);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

