/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.reassign;

import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandDefaultOptions;

public class ReassignPartitionsCommandOptions
extends CommandDefaultOptions {
    final OptionSpec<?> verifyOpt;
    final OptionSpec<?> generateOpt;
    final OptionSpec<?> executeOpt;
    final OptionSpec<?> cancelOpt;
    final OptionSpec<?> listOpt;
    final OptionSpec<String> bootstrapServerOpt;
    final OptionSpec<String> commandConfigOpt;
    final OptionSpec<String> reassignmentJsonFileOpt;
    final OptionSpec<String> topicsToMoveJsonFileOpt;
    final OptionSpec<String> brokerListOpt;
    final OptionSpec<?> disableRackAware;
    final OptionSpec<Long> interBrokerThrottleOpt;
    final OptionSpec<Long> replicaAlterLogDirsThrottleOpt;
    final OptionSpec<Long> timeoutOpt;
    final OptionSpec<?> additionalOpt;
    final OptionSpec<?> preserveThrottlesOpt;

    public ReassignPartitionsCommandOptions(String[] args) {
        super(args);
        this.verifyOpt = this.parser.accepts("verify", "Verify if the reassignment completed as specified by the --reassignment-json-file option. If there is a throttle engaged for the replicas specified, and the rebalance has completed, the throttle will be removed");
        this.generateOpt = this.parser.accepts("generate", "Generate a candidate partition reassignment configuration. Note that this only generates a candidate assignment, it does not execute it.");
        this.executeOpt = this.parser.accepts("execute", "Kick off the reassignment as specified by the --reassignment-json-file option.");
        this.cancelOpt = this.parser.accepts("cancel", "Cancel an active reassignment.");
        this.listOpt = this.parser.accepts("list", "List all active partition reassignments.");
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: the server(s) to use for bootstrapping.").withRequiredArg().describedAs("Server(s) to use for bootstrapping").ofType(String.class);
        this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("Admin client property file").ofType(String.class);
        this.reassignmentJsonFileOpt = this.parser.accepts("reassignment-json-file", "The JSON file with the partition reassignment configurationThe format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3],\n\t  \"log_dirs\": [\"dir1\",\"dir2\",\"dir3\"] }],\n\"version\":1\n}\nNote that \"log_dirs\" is optional. When it is specified, its length must equal the length of the replicas list. The value in this list can be either \"any\" or the absolution path of the log directory on the broker. If absolute log directory path is specified, the replica will be moved to the specified log directory on the broker.").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        this.topicsToMoveJsonFileOpt = this.parser.accepts("topics-to-move-json-file", "Generate a reassignment configuration to move the partitions of the specified topics to the list of brokers specified by the --broker-list option. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        this.brokerListOpt = this.parser.accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required if --topics-to-move-json-file is used to generate reassignment configuration").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        this.disableRackAware = this.parser.accepts("disable-rack-aware", "Disable rack aware replica assignment");
        this.interBrokerThrottleOpt = this.parser.accepts("throttle", "The movement of partitions between brokers will be throttled to this value (bytes/sec). This option can be included with --execute when a reassignment is started, and it can be altered by resubmitting the current reassignment along with the --additional flag. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("throttle").ofType(Long.class).defaultsTo((Object)-1L, (Object[])new Long[0]);
        this.replicaAlterLogDirsThrottleOpt = this.parser.accepts("replica-alter-log-dirs-throttle", "The movement of replicas between log directories on the same broker will be throttled to this value (bytes/sec). This option can be included with --execute when a reassignment is started, and it can be altered by resubmitting the current reassignment along with the --additional flag. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("replicaAlterLogDirsThrottle").ofType(Long.class).defaultsTo((Object)-1L, (Object[])new Long[0]);
        this.timeoutOpt = this.parser.accepts("timeout", "The maximum time in ms to wait for log directory replica assignment to begin.").withRequiredArg().describedAs("timeout").ofType(Long.class).defaultsTo((Object)10000L, (Object[])new Long[0]);
        this.additionalOpt = this.parser.accepts("additional", "Execute this reassignment in addition to any other ongoing ones. This option can also be used to change the throttle of an ongoing reassignment.");
        this.preserveThrottlesOpt = this.parser.accepts("preserve-throttles", "Do not modify broker or topic throttles.");
        this.options = this.parser.parse(args);
    }
}

