/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.ZkAdminManager$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zk.migration.ZkConfigMigrationClient$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u000b\u0017\u0001uA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)\u0011\t\u0001C\u0001\u0005\"9q\t\u0001b\u0001\n\u0003A\u0005B\u0002'\u0001A\u0003%\u0011\nC\u0003N\u0001\u0011%a\nC\u0003_\u0001\u0011%q\fC\u0003b\u0001\u0011%!\rC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a&\u0001\t\u0013\tIjB\u0004\u0002>ZA\t!a0\u0007\rU1\u0002\u0012AAa\u0011\u0019\t%\u0003\"\u0001\u0002J\"9\u00111\u001a\n\u0005\u0002\u00055'a\u0006.l\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0015\t9\u0002$A\u0005nS\u001e\u0014\u0018\r^5p]*\u0011\u0011DG\u0001\u0003u.T\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001aD\n\u001a\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001\u00027b]\u001eT\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t1qJ\u00196fGR\u0004\"a\n\u0019\u000e\u0003!R!aF\u0015\u000b\u0005)Z\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005ma#BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!\r\u0015\u0003+\r{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oiB\u00111GN\u0007\u0002i)\u0011QGG\u0001\u0006kRLGn]\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\tQ4(D\u0001\u0019\u0013\ta\u0004DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0010a\u0006\u001c8o^8sI\u0016s7m\u001c3feB\u00111gP\u0005\u0003\u0001R\u0012q\u0002U1tg^|'\u000fZ#oG>$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\ta\u0003C\u00039\u0007\u0001\u0007\u0011\bC\u0003>\u0007\u0001\u0007a(A\u0007bI6LgNW6DY&,g\u000e^\u000b\u0002\u0013B\u0011!HS\u0005\u0003\u0017b\u0011Q\"\u00113nS:T6n\u00117jK:$\u0018AD1e[&t'l[\"mS\u0016tG\u000fI\u0001\u0017MJ|WNW6D_:4\u0017nZ#oi&$\u0018PT1nKR\u0011q\n\u0018\t\u0003!fs!!U,\u0011\u0005I+V\"A*\u000b\u0005Qc\u0012A\u0002\u001fs_>$hHC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAV+\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-V\u0011\u0015if\u00011\u0001P\u0003))g\u000e^5us:\u000bW.Z\u0001\u0015i>T6nQ8oM&<WI\u001c;jift\u0015-\\3\u0015\u0005=\u0003\u0007\"B/\b\u0001\u0004y\u0015A\u00072vS2$7\t\\5f]R\fVo\u001c;b\u000b:$\u0018\u000e^=ECR\fGcA2xsB\u0011A\r\u001e\b\u0003KFt!AZ8\u000f\u0005\u001dlgB\u00015m\u001d\tI7N\u0004\u0002SU&\tq&\u0003\u0002.]%\u00111\u0004L\u0005\u0003].\naaY8n[>t\u0017B\u0001\u0016q\u0015\tq7&\u0003\u0002sg\u0006\t2\t\\5f]R\fVo\u001c;b%\u0016\u001cwN\u001d3\u000b\u0005)\u0002\u0018BA;w\u0005))e\u000e^5us\u0012\u000bG/\u0019\u0006\u0003eNDQ\u0001\u001f\u0005A\u0002=\u000b!\"\u001a8uSRLH+\u001f9f\u0011\u0015Q\b\u00021\u0001P\u0003%Qhn\u001c3f\u001d\u0006lW-A\nji\u0016\u0014\u0018\r^3DY&,g\u000e^)v_R\f7\u000fF\u0002~\u0003\u0007\u0001\"A`@\u000e\u0003UK1!!\u0001V\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u00059a/[:ji>\u0014\b\u0003BA\u0005\u0003/qA!a\u0003\u0002\u00149!\u0011QBA\t\u001d\r9\u0017qB\u0005\u0003U-J!aF\u0015\n\u0007\u0005U\u0001&A\u000bD_:4\u0017nZ'jOJ\fG/[8o\u00072LWM\u001c;\n\t\u0005e\u00111\u0004\u0002\u0013\u00072LWM\u001c;Rk>$\u0018MV5tSR|'OC\u0002\u0002\u0016!\nA#\u001b;fe\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cHcA?\u0002\"!9\u00111\u0005\u0006A\u0002\u0005\u0015\u0012AD2p]\u001aLwmQ8ogVlWM\u001d\t\b\u0003O\t\tdTA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0005=\"%\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003S\u0011!BQ5D_:\u001cX/\\3s!\u0019\t9$!\u000fP\u001f6\u0011\u0011QF\u0005\u0005\u0003w\tiCA\u0002NCB\f1#\u001b;fe\u0006$X\rV8qS\u000e\u001cuN\u001c4jON$2!`A!\u0011\u001d\t\u0019c\u0003a\u0001\u0003K\t\u0001C]3bIR{\u0007/[2D_:4\u0017nZ:\u0015\u000bu\f9%a\u0013\t\r\u0005%C\u00021\u0001P\u0003%!x\u000e]5d\u001d\u0006lW\rC\u0004\u0002$1\u0001\r!!\u0014\u0011\r\u0005\u001d\u0012qJA\u001b\u0013\u0011\t\t&!\u000b\u0003\u0011\r{gn];nKJ\fAb\u001e:ji\u0016\u001cuN\u001c4jON$\u0002\"a\u0016\u0002^\u00055\u0014\u0011\u000f\t\u0004O\u0005e\u0013bAA.Q\tQ\"l['jOJ\fG/[8o\u0019\u0016\fG-\u001a:tQ&\u00048\u000b^1uK\"9\u0011qL\u0007A\u0002\u0005\u0005\u0014AD2p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r9\u0002\r\r|gNZ5h\u0013\u0011\tY'!\u001a\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\"9\u0011qN\u0007A\u0002\u0005U\u0012!C2p]\u001aLw-T1q\u0011\u001d\t\u0019(\u0004a\u0001\u0003/\nQa\u001d;bi\u0016\fQ\u0002Z3mKR,7i\u001c8gS\u001e\u001cHCBA,\u0003s\nY\bC\u0004\u0002`9\u0001\r!!\u0019\t\u000f\u0005Md\u00021\u0001\u0002X\u0005\trO]5uK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\u0015\u0005]\u0013\u0011QAC\u0003#\u000b)\nC\u0004\u0002\u0004>\u0001\r!!\u000e\u0002\r\u0015tG/\u001b;z\u0011\u001d\t9i\u0004a\u0001\u0003\u0013\u000ba!];pi\u0006\u001c\bcBA\u001c\u0003sy\u00151\u0012\t\u0004?\u00055\u0015bAAHA\t1Ai\\;cY\u0016Dq!a%\u0010\u0001\u0004\t)$A\u0003tGJ\fW\u000eC\u0004\u0002t=\u0001\r!a\u0016\u0002)Q\u0014\u0018p\u0016:ji\u0016,e\u000e^5us\u000e{gNZ5h)1\tY*!)\u0002$\u0006\u001d\u0016\u0011WA^!\u0015q\u0018QTA,\u0013\r\ty*\u0016\u0002\u0007\u001fB$\u0018n\u001c8\t\u000ba\u0004\u0002\u0019A(\t\r\u0005\u0015\u0006\u00031\u0001P\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005%\u0006\u00031\u0001\u0002,\u0006)\u0001O]8qgB!\u0011qGAW\u0013\u0011\ty+!\f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u00024B\u0001\r!!.\u0002\r\r\u0014X-\u0019;f!\rq\u0018qW\u0005\u0004\u0003s+&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g\u0002\u0002\u0019AA,\u0003]Q6nQ8oM&<W*[4sCRLwN\\\"mS\u0016tG\u000f\u0005\u0002E%M\u0019!#a1\u0011\u0007y\f)-C\u0002\u0002HV\u0013a!\u00118z%\u00164GCAA`\u0003\u0001:W\r^*b]&$\u0018N_3e\u00072LWM\u001c;Rk>$\u0018M\u0017(pI\u0016t\u0015-\\3\u0015\r\u0005=\u0017\u0011[Aj!\u0011q\u0018QT(\t\u000f\u0005\rE\u00031\u0001\u00026!1\u0011Q\u001b\u000bA\u0002=\u000b\u0011bY8na>tWM\u001c;")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> getSanitizedClientQuotaZNodeName(java.util.Map<String, String> map, String string) {
        return ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(map, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkConfigEntityName(String entityName) {
        if (entityName.equals(ConfigEntityName$.MODULE$.Default())) {
            return "";
        }
        return entityName;
    }

    private String toZkConfigEntityName(String entityName) {
        if (entityName.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        return entityName;
    }

    private ClientQuotaRecord.EntityData buildClientQuotaEntityData(String entityType, String znodeName) {
        ClientQuotaRecord.EntityData result = new ClientQuotaRecord.EntityData().setEntityType(entityType);
        if (znodeName.equals(ConfigEntityName$.MODULE$.Default())) {
            result.setEntityName(null);
        } else {
            result.setEntityName(Sanitizer.desanitize((String)znodeName));
        }
        return result;
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1(ConfigType$.MODULE$.User(), "user", visitor);
        this.migrateEntityType$1(ConfigType$.MODULE$.Client(), "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs(ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1(ConfigType$.MODULE$.Ip(), "ip", visitor);
    }

    public void iterateBrokerConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Broker());
        this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.Broker(), (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String $anonfun$iterateBrokerConfigs$1_broker = (String)x0$1._1();
                Properties $anonfun$iterateBrokerConfigs$1_props = (Properties)x0$1._2();
                String $anonfun$iterateBrokerConfigs$1_brokerResource = this.fromZkConfigEntityName($anonfun$iterateBrokerConfigs$1_broker);
                java.util.Map $anonfun$iterateBrokerConfigs$1_decodedProps = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter($anonfun$iterateBrokerConfigs$1_props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        String value = (String)x0$2._2();
                        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                    }
                    throw new MatchError(null);
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
                String string = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append($anonfun$iterateBrokerConfigs$1_brokerResource).append(".").toString();
                if (ZkMigrationClient$.MODULE$ == null) {
                    throw null;
                }
                try {
                    configConsumer.accept($anonfun$iterateBrokerConfigs$1_brokerResource, $anonfun$iterateBrokerConfigs$1_decodedProps);
                }
                catch (Throwable $anonfun$iterateBrokerConfigs$1_logAndRethrow_e) {
                    void $anonfun$iterateBrokerConfigs$1_logAndRethrow_msg;
                    this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)$anonfun$iterateBrokerConfigs$1_logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2($anonfun$iterateBrokerConfigs$1_logAndRethrow_e)));
                    throw $anonfun$iterateBrokerConfigs$1_logAndRethrow_e;
                }
            } else {
                throw new MatchError(null);
            }
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.readTopicConfigs((String)topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkConfigEntityName(topicName);
        Properties props = this.zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topicResource);
        java.util.Map decodedProps = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        String string = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            configConsumer.accept(decodedProps);
            return;
        }
        catch (Throwable logAndRethrow_e) {
            void logAndRethrow_msg;
            this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        ZkMigrationLeadershipState zkMigrationLeadershipState;
        Object object = new Object();
        try {
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                    throw throwable;
                }
                if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
        return zkMigrationLeadershipState;
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)$this.buildClientQuotaEntityData(entityType$1, name), (List)Nil$.MODULE$)).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1))))).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String string = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    if (ZkMigrationClient$.MODULE$ == null) {
                        throw null;
                    }
                    try {
                        visitor$1.visitScramCredential(Sanitizer.desanitize((String)name), mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        void logAndRethrow_msg;
                        $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    double value = x0$2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            if (!quotaMap.isEmpty()) {
                String string = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                if (ZkMigrationClient$.MODULE$ == null) {
                    throw null;
                }
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                    return;
                }
                catch (Throwable logAndRethrow_e) {
                    void logAndRethrow_msg;
                    $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block6: {
            String[] components;
            Properties props;
            block8: {
                String znodePath;
                block7: {
                    if (x0$1 == null) break block6;
                    znodePath = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = znodePath.split("/");
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).size() != 3) break block7;
                    String string = components[1];
                    String string2 = "clients";
                    if (string != null && string.equals(string2)) break block8;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(znodePath).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildClientQuotaEntityData("user", components[0]), (List)new .colon.colon((Object)$this.buildClientQuotaEntityData("client-id", components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Double d;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                    Double doubleValue = d;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom())).asJava();
            String string = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                visitor$1.visitClientQuota((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkConfigEntityName(broker);
            java.util.Map decodedProps = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            String string = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                configConsumer$1.accept(brokerResource, decodedProps);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopicConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$2, String topic) {
        $this.readTopicConfigs(topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1) {
        ConfigResource.Type type = configResource$1.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : None$.MODULE$);
        String configName = $this.toZkConfigEntityName(configResource$1.name());
        if (configType.isDefined()) {
            Properties props = new Properties();
            configMap$1.forEach((x0$1, x1$1) -> {
                String key = x0$1;
                String value = x1$1;
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    props.put(key, $this.passwordEncoder.encode(new Password(value)));
                    return;
                }
                props.put(key, value);
            });
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state$1);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                boolean x$2 = false;
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, x$2);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state$1);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : None$.MODULE$);
        String configName = $this.toZkConfigEntityName(configResource$2.name());
        if (configType.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)configType.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(configType.get()).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    public static final /* synthetic */ void $anonfun$writeClientQuotas$3(java.util.Map configKeys$1, Properties props$3, String x0$1, Double x1$1) {
        String key = x0$1;
        Double value = x1$1;
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys$1.get(key);
        if (configKey == null) {
            throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append(key).toString());
        }
        ConfigDef.Type type = configKey.type;
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            props$3.setProperty(key, value.toString());
            return;
        }
        if (ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type)) {
            long intValue;
            double epsilon = 1.0E-6;
            ConfigDef.Type type2 = configKey.type;
            ConfigDef.Type type3 = ConfigDef.Type.LONG;
            long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(value) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(value) + epsilon)));
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(value))) > epsilon) {
                throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append(key).append(" must be a ").append(configKey.type).append(" value").toString());
            }
            props$3.setProperty(key, Long.toString(intValue));
            return;
        }
        throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        void var12_14;
        void var11_13;
        void var10_12;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Some some;
        Some some2;
        Some user = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "user");
        Some client = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "client-id");
        Some ip = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "ip");
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some2 = new Some((Object)ConfigType$.MODULE$.User());
            some = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some2 = new Some((Object)ConfigType$.MODULE$.User());
            some = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some2 = new Some((Object)ConfigType$.MODULE$.Client());
            some = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some2 = new Some((Object)ConfigType$.MODULE$.Ip());
            some = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else {
            some2 = None$.MODULE$;
            some = None$.MODULE$;
            map = CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Some some3 = some;
        Option configType = (Option)some2;
        Some path = some3;
        java.util.Map<String, ConfigDef.ConfigKey> configKeys = map2;
        void configType2 = var10_12;
        void path2 = var11_13;
        void configKeys2 = var12_14;
        if (path2.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((arg_0, arg_1) -> ZkConfigMigrationClient.$anonfun$writeClientQuotas$3((java.util.Map)configKeys2, props, arg_0, arg_1));
        scram$1.forEach((x0$2, x1$2) -> {
            String key = x0$2;
            String value = x1$2;
            props.put(key, value);
        });
        Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, false, state$3);
        if (option instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get());
            boolean x$2 = false;
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, x$2);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, true, state$3);
            if (option2 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option2).value();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$4, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4) {
        void var10_10;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$4);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), SetDataRequest$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var9_9;
            $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            return new Some((Object)state$4.withMigrationZkVersion((int)var9_9));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var10_10.head()).resultCode(), (String)path$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        Logging.$init$(this);
        this.adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
    }
}

