/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.ControllerDynamicThreadPool;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicProducerStateManagerConfig;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0011Es!B-[\u0011\u0003yf!B1[\u0011\u0003\u0011\u0007\"B5\u0002\t\u0003Q\u0007\u0002C6\u0002\u0005\u0004%\tA\u00177\t\ru\f\u0001\u0015!\u0003n\u0011\u001dq\u0018A1A\u0005\u00021Daa`\u0001!\u0002\u0013i\u0007\"CA\u0001\u0003\t\u0007I\u0011BA\u0002\u0011!\tY!\u0001Q\u0001\n\u0005\u0015\u0001\u0002CA\u0007\u0003\t\u0007I\u0011\u00027\t\u000f\u0005=\u0011\u0001)A\u0005[\"I\u0011\u0011C\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003'\t\u0001\u0015!\u0003\u0002\u0006!I\u0011QC\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003/\t\u0001\u0015!\u0003\u0002\u0006!I\u0011\u0011D\u0001C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003[\t\u0001\u0015!\u0003\u0002\u001e!A\u0011qF\u0001C\u0002\u0013%A\u000eC\u0004\u00022\u0005\u0001\u000b\u0011B7\t\u000f\u0005M\u0012\u0001\"\u0001\u00026!9\u0011QK\u0001\u0005\u0002\u0005]\u0003bBA9\u0003\u0011\u0005\u00111\u000f\u0005\b\u0003\u001b\u000bA\u0011BAH\u0011\u001d\t)*\u0001C\u0005\u0003/Cq!a'\u0002\t\u0013\ti\nC\u0004\u0002\"\u0006!I!a)\t\u0011\u0005\u001d\u0016\u0001\"\u0001[\u0003SC\u0001\"!3\u0002\t\u0003Q\u00161\u001a\u0005\t\u0003'\fA\u0011\u0001.\u0002V\u001a)\u0011M\u0017\u0001\u0002\\\"Q\u0011\u0011^\u000f\u0003\u0006\u0004%I!a;\t\u0015\u0005MXD!A!\u0002\u0013\ti\u000f\u0003\u0004j;\u0011\u0005\u0011Q\u001f\u0005\u000b\u0003wl\"\u0019!C\u00015\u0006u\b\u0002\u0003B\u0002;\u0001\u0006I!a@\t\u0015\t\u0015QD1A\u0005\u0002i\u000bi\u0010\u0003\u0005\u0003\bu\u0001\u000b\u0011BA\u0000\u0011%\u0011I!\bb\u0001\n\u0013\u0011Y\u0001\u0003\u0005\u0003\u0010u\u0001\u000b\u0011\u0002B\u0007\u0011%\u0011\t\"\bb\u0001\n\u0013\u0011Y\u0001\u0003\u0005\u0003\u0014u\u0001\u000b\u0011\u0002B\u0007\u0011)\u0011)\"\bb\u0001\n\u0003Q&q\u0003\u0005\t\u0005[i\u0002\u0015!\u0003\u0003\u001a!I!qF\u000fC\u0002\u0013%!\u0011\u0007\u0005\t\u0005wi\u0002\u0015!\u0003\u00034!I!QH\u000fC\u0002\u0013%!q\b\u0005\t\u0005\u001bj\u0002\u0015!\u0003\u0003B!Y!qJ\u000fA\u0002\u0003\u0007I\u0011\u0002B)\u0011-\u00119'\ba\u0001\u0002\u0004%IA!\u001b\t\u0017\t=T\u00041A\u0001B\u0003&!1\u000b\u0005\f\u0005cj\u0002\u0019!a\u0001\n\u0013\tY\u000fC\u0006\u0003tu\u0001\r\u00111A\u0005\n\tU\u0004b\u0003B=;\u0001\u0007\t\u0011)Q\u0005\u0003[D\u0011Ba\u001f\u001e\u0005\u0004%IA! \t\u0011\t\u001dU\u0004)A\u0005\u0005\u007fB\u0001B!#\u001e\t\u0003Q&1\u0012\u0005\t\u0005GkB\u0011\u0001.\u0003&\"9!qU\u000f\u0005\u0002\t%\u0006b\u0002BT;\u0011\u0005!Q\u0017\u0005\b\u0005\u0003lB\u0011\u0001Bb\u0011\u001d\u0011I-\bC\u0001\u0005\u0017DqAa4\u001e\t\u0003\u0011\t\u000eC\u0004\u0003Vv!IAa6\t\u0011\tuW\u0004\"\u0001[\u0003WD\u0001Ba8\u001e\t\u0003Q&\u0011\u001d\u0005\t\u0005OlB\u0011\u0001.\u0003b\"A!\u0011^\u000f\u0005\u0002i\u0013\t\u0006\u0003\u0005\u0003lv!\tA\u0017Bw\u0011)\u0019\t!HI\u0001\n\u0003Q61\u0001\u0005\t\u00073iB\u0011\u0001.\u0004\u001c!Q1\u0011E\u000f\u0012\u0002\u0013\u0005!la\u0001\t\u0011\r\rR\u0004\"\u0001[\u0007KAqaa\u000b\u001e\t\u0013\u0019i\u0003C\u0004\u0004Bu!Iaa\u0011\t\u0011\r\u0015S\u0004\"\u0001[\u0007\u000fB\u0001ba\u0014\u001e\t\u0003Q6\u0011\u000b\u0005\b\u0007/jB\u0011BB-\u0011\u001d\u00199'\bC\u0005\u0007SB\u0001b!\u001d\u001e\t\u0003Q61\u000f\u0005\b\u0007sjB\u0011BB>\u0011!\u0019\t)\bC\u00015\u000e\r\u0005bBBU;\u0011%11\u0016\u0005\b\u0007/lB\u0011BBm\u0011\u001d\u0019y.\bC\u0005\u0007CDqa!:\u001e\t\u0013\u00199\u000fC\u0005\u0004vv\t\n\u0011\"\u0003\u0004\u0004!91q_\u000f\u0005\n\re\bb\u0002C\u0006;\u0011%AQ\u0002\u0005\b\tgiB\u0011\u0002C\u001b\u0003M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h\u0015\tYF,\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0006)1.\u00194lC\u000e\u0001\u0001C\u00011\u0002\u001b\u0005Q&a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7CA\u0001d!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aX\u0001\u0017\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hgV\tQ\u000eE\u0002ogVl\u0011a\u001c\u0006\u0003aF\fq!\\;uC\ndWM\u0003\u0002sK\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q|'aA*fiB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005Y\u0006twMC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(AB*ue&tw-A\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4tA\u0005\t\u0012\t\u001c7Es:\fW.[2D_:4\u0017nZ:\u0002%\u0005cG\u000eR=oC6L7mQ8oM&<7\u000fI\u0001\u001c\u00072,8\u000f^3s\u0019\u00164X\r\u001c'jgR,g.\u001a:D_:4\u0017nZ:\u0016\u0005\u0005\u0015\u0001#BA\u0004\u0003\u0013)X\"A9\n\u0005Q\f\u0018\u0001H\"mkN$XM\u001d'fm\u0016dG*[:uK:,'oQ8oM&<7\u000fI\u0001\u0011!\u0016\u0014(I]8lKJ\u001cuN\u001c4jON\f\u0011\u0003U3s\u0005J|7.\u001a:D_:4\u0017nZ:!\u0003aa\u0015n\u001d;f]\u0016\u0014X*Z2iC:L7/\\\"p]\u001aLwm]\u0001\u001a\u0019&\u001cH/\u001a8fe6+7\r[1oSNl7i\u001c8gS\u001e\u001c\b%A\u000bSK2|\u0017\rZ1cY\u00164\u0015\u000e\\3D_:4\u0017nZ:\u0002-I+Gn\\1eC\ndWMR5mK\u000e{gNZ5hg\u0002\n1\u0003T5ti\u0016tWM]\"p]\u001aLwMU3hKb,\"!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005AQ.\u0019;dQ&twMC\u0002\u0002(\u0015\fA!\u001e;jY&!\u00111FA\u0011\u0005\u0015\u0011VmZ3y\u0003Qa\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3yA\u00051B)\u001f8b[&\u001c\u0007+Y:to>\u0014HmQ8oM&<7/A\fEs:\fW.[2QCN\u001cxo\u001c:e\u0007>tg-[4tA\u0005\u0001\u0012n\u001d)bgN<xN\u001d3D_:4\u0017n\u001a\u000b\u0005\u0003o\ti\u0004E\u0002e\u0003sI1!a\u000ff\u0005\u001d\u0011un\u001c7fC:Dq!a\u0010\u0014\u0001\u0004\t\t%\u0001\u0003oC6,\u0007\u0003BA\"\u0003#rA!!\u0012\u0002NA\u0019\u0011qI3\u000e\u0005\u0005%#bAA&=\u00061AH]8pizJ1!a\u0014f\u0003\u0019\u0001&/\u001a3fM&\u0019A0a\u0015\u000b\u0007\u0005=S-\u0001\u000bce>\\WM]\"p]\u001aLwmU=o_:LXn\u001d\u000b\u0007\u00033\nY'!\u001c\u0011\r\u0005m\u0013QMA!\u001d\u0011\ti&!\u0019\u000f\t\u0005\u001d\u0013qL\u0005\u0002M&\u0019\u00111M3\u0002\u000fA\f7m[1hK&!\u0011qMA5\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\rT\rC\u0004\u0002@Q\u0001\r!!\u0011\t\u000f\u0005=D\u00031\u0001\u00028\u0005)R.\u0019;dQ2K7\u000f^3oKJ|e/\u001a:sS\u0012,\u0017a\u0004<bY&$\u0017\r^3D_:4\u0017nZ:\u0015\r\u0005U\u00141PAE!\r!\u0017qO\u0005\u0004\u0003s*'\u0001B+oSRDq!! \u0016\u0001\u0004\ty(A\u0003qe>\u00048\u000f\u0005\u0003\u0002\u0002\u0006\u0015UBAAB\u0015\r\t9#_\u0005\u0005\u0003\u000f\u000b\u0019I\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a#\u0016\u0001\u0004\t9$A\bqKJ\u0014%o\\6fe\u000e{gNZ5h\u0003A\u0001XM\u001d\"s_.,'oQ8oM&<7\u000f\u0006\u0003\u0002\u0012\u0006M\u0005CBA\u0004\u0003\u0013\t\t\u0005C\u0004\u0002~Y\u0001\r!a \u0002#9|g\u000eR=oC6L7mQ8oM&<7\u000f\u0006\u0003\u0002\u0012\u0006e\u0005bBA?/\u0001\u0007\u0011qP\u0001%g\u0016\u001cWO]5us\u000e{gNZ5hg^KG\u000f[8vi2K7\u000f^3oKJ\u0004&/\u001a4jqR!\u0011\u0011SAP\u0011\u001d\ti\b\u0007a\u0001\u0003\u007f\n1C^1mS\u0012\fG/Z\"p]\u001aLw\rV=qKN$B!!\u001e\u0002&\"9\u0011QP\rA\u0002\u0005}\u0014!E1eI\u0012Kh.Y7jG\u000e{gNZ5hgR!\u0011QOAV\u0011\u001d\tiK\u0007a\u0001\u0003_\u000b\u0011bY8oM&<G)\u001a4\u0011\t\u0005E\u0016QY\u0007\u0003\u0003gSA!!.\u00028\u000611m\u001c8gS\u001eTA!!/\u0002<\u000611m\\7n_:T1!XA_\u0015\u0011\ty,!1\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019-A\u0002pe\u001eLA!a2\u00024\nI1i\u001c8gS\u001e$UMZ\u0001\u0019Ift\u0017-\\5d\u0007>tg-[4Va\u0012\fG/Z'pI\u0016\u001cXCAAg!!\t\t)a4\u0002B\u0005\u0005\u0013\u0002BAi\u0003\u0007\u00131!T1q\u0003Y\u0011Xm]8mm\u00164\u0016M]5bE2,7i\u001c8gS\u001e\u001cH\u0003BA@\u0003/Dq!!7\u001d\u0001\u0004\ty(A\u0007qe>\u00048o\u0014:jO&t\u0017\r\\\n\u0005;\r\fi\u000e\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019\u000fX\u0001\u0006kRLGn]\u0005\u0005\u0003O\f\tOA\u0004M_\u001e<\u0017N\\4\u0002\u0017-\fgm[1D_:4\u0017nZ\u000b\u0003\u0003[\u00042\u0001YAx\u0013\r\t\tP\u0017\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0007lC\u001a\\\u0017mQ8oM&<\u0007\u0005\u0006\u0003\u0002x\u0006e\bC\u00011\u001e\u0011\u001d\tI\u000f\ta\u0001\u0003[\f1c\u001d;bi&\u001c'I]8lKJ\u001cuN\u001c4jON,\"!a@\u0011\u000b9\u0014\t!^;\n\u0007\u0005Ew.\u0001\u000bti\u0006$\u0018n\u0019\"s_.,'oQ8oM&<7\u000fI\u0001\u0015gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002+M$\u0018\r^5d\t\u00164\u0017-\u001e7u\u0007>tg-[4tA\u0005!B-\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON,\"A!\u0004\u0011\u000f9\u0014\t!!\u0011\u0002B\u0005)B-\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON\u0004\u0013!\u00063z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0017Ift\u0017-\\5d\t\u00164\u0017-\u001e7u\u0007>tg-[4tA\u0005y!/Z2p]\u001aLw-\u001e:bE2,7/\u0006\u0002\u0003\u001aA1!1\u0004B\u0011\u0005Ki!A!\b\u000b\t\t}\u00111Q\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\u0012\u0005;\u0011AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\b\u0003\u0002B\u0014\u0005Si!!a.\n\t\t-\u0012q\u0017\u0002\u000f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003A\u0011XmY8oM&<WO]1cY\u0016\u001c\b%A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\tM\u0002C\u0002B\u000e\u0005C\u0011)\u0004E\u0002a\u0005oI1A!\u000f[\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u00061\"M]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u001c\b%\u0001\u0003m_\u000e\\WC\u0001B!!\u0011\u0011\u0019E!\u0013\u000e\u0005\t\u0015#\u0002\u0002B$\u0005;\tQ\u0001\\8dWNLAAa\u0013\u0003F\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\rnKR\u0014\u0018nY:SK\u000e,\u0017N^3s!2,x-\u001b8PaR,\"Aa\u0015\u0011\u000b\u0011\u0014)F!\u0017\n\u0007\t]SM\u0001\u0004PaRLwN\u001c\t\u0005\u00057\u0012\u0019'\u0004\u0002\u0003^)!!q\fB1\u0003\u001diW\r\u001e:jGNT1aWA^\u0013\u0011\u0011)G!\u0018\u00037\rc\u0017.\u001a8u\u001b\u0016$(/[2t%\u0016\u001cW-\u001b<feBcWoZ5o\u0003qiW\r\u001e:jGN\u0014VmY3jm\u0016\u0014\b\u000b\\;hS:|\u0005\u000f^0%KF$B!!\u001e\u0003l!I!Q\u000e\u0019\u0002\u0002\u0003\u0007!1K\u0001\u0004q\u0012\n\u0014!G7fiJL7m\u001d*fG\u0016Lg/\u001a:QYV<\u0017N\\(qi\u0002\nQbY;se\u0016tGoQ8oM&<\u0017!E2veJ,g\u000e^\"p]\u001aLwm\u0018\u0013fcR!\u0011Q\u000fB<\u0011%\u0011igMA\u0001\u0002\u0004\ti/\u0001\bdkJ\u0014XM\u001c;D_:4\u0017n\u001a\u0011\u00029\u0011Lh.Y7jG\u000e{gNZ5h!\u0006\u001c8o^8sI\u0016s7m\u001c3feV\u0011!q\u0010\t\u0006I\nU#\u0011\u0011\t\u0005\u0003?\u0014\u0019)\u0003\u0003\u0003\u0006\u0006\u0005(a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\u0002;\u0011Lh.Y7jG\u000e{gNZ5h!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0019\t)H!$\u0003 \"9!qR\u001cA\u0002\tE\u0015a\u0003>l\u00072LWM\u001c;PaR\u0004R\u0001\u001aB+\u0005'\u0003BA!&\u0003\u001c6\u0011!q\u0013\u0006\u0004\u00053c\u0016A\u0001>l\u0013\u0011\u0011iJa&\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u001d\u0011\tk\u000ea\u0001\u0005'\nad\u00197jK:$X*\u001a;sS\u000e\u001c(+Z2fSZ,'\u000f\u00157vO&tw\n\u001d;\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005U\u0014AE1eIJ+7m\u001c8gS\u001e,(/\u00192mKN$B!!\u001e\u0003,\"9!QV\u001dA\u0002\t=\u0016aC6bM.\f7+\u001a:wKJ\u00042\u0001\u0019BY\u0013\r\u0011\u0019L\u0017\u0002\f\u0017\u000647.\u0019\"s_.,'\u000f\u0006\u0003\u0002v\t]\u0006b\u0002B]u\u0001\u0007!1X\u0001\u000bG>tGO]8mY\u0016\u0014\bc\u00011\u0003>&\u0019!q\u0018.\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018!E1eIJ+7m\u001c8gS\u001e,(/\u00192mKR!\u0011Q\u000fBc\u0011\u001d\u00119m\u000fa\u0001\u0005K\taB]3d_:4\u0017nZ;sC\ndW-A\fbI\u0012\u0014%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKR!\u0011Q\u000fBg\u0011\u001d\u00119\r\u0010a\u0001\u0005k\tAC]3n_Z,'+Z2p]\u001aLw-\u001e:bE2,G\u0003BA;\u0005'DqAa2>\u0001\u0004\u0011)#A\u000ewKJLg-\u001f*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0005\u0003k\u0012I\u000eC\u0004\u0003\\z\u0002\r!!%\u0002\u0017\r|gNZ5h\u001d\u0006lWm]\u0001\u0013GV\u0014(/\u001a8u\u0017\u000647.Y\"p]\u001aLw-A\u000edkJ\u0014XM\u001c;Es:\fW.[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0005G\u0004\u0002\"a\u0002\u0003f\u0006\u0005\u0013\u0011I\u0005\u0004\u0003#\f\u0018\u0001H2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u001cG2LWM\u001c;NKR\u0014\u0018nY:SK\u000e,\u0017N^3s!2,x-\u001b8\u0002%U\u0004H-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\t\u0003k\u0012yO!?\u0003~\"9!\u0011_\"A\u0002\tM\u0018\u0001\u00032s_.,'/\u00133\u0011\u0007\u0011\u0014)0C\u0002\u0003x\u0016\u00141!\u00138u\u0011\u001d\u0011Yp\u0011a\u0001\u0003\u007f\nq\u0002]3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u0005\n\u0005\u007f\u001c\u0005\u0013!a\u0001\u0003o\tQ\u0001Z8M_\u001e\fA$\u001e9eCR,'I]8lKJ\u001cuN\u001c4jO\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\u0006)\"\u0011qGB\u0004W\t\u0019I\u0001\u0005\u0003\u0004\f\rUQBAB\u0007\u0015\u0011\u0019ya!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAB\nK\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r]1Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE;qI\u0006$X\rR3gCVdGoQ8oM&<GCBA;\u0007;\u0019y\u0002C\u0004\u0003|\u0016\u0003\r!a \t\u0013\t}X\t%AA\u0002\u0005]\u0012!H;qI\u0006$X\rR3gCVdGoQ8oM&<G\u0005Z3gCVdG\u000f\n\u001a\u0002KI,Gn\\1e+B$\u0017\r^3e\r&dWm],ji\"|W\u000f^\"p]\u001aLwm\u00115b]\u001e,G\u0003BA;\u0007OAqa!\u000bH\u0001\u0004\ty(\u0001\u0005oK^\u0004&o\u001c9t\u0003ii\u0017-\u001f2f\u0007J,\u0017\r^3QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s)\u0011\u0011yha\f\t\u000f\rE\u0002\n1\u0001\u00044\u000511/Z2sKR\u0004R\u0001\u001aB+\u0007k\u0001Baa\u000e\u0004>5\u00111\u0011\b\u0006\u0005\u0007w\t\u0019,A\u0003usB,7/\u0003\u0003\u0004@\re\"\u0001\u0003)bgN<xN\u001d3\u0002\u001fA\f7o]<pe\u0012,enY8eKJ,\"A!!\u0002#Q|\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0006\u0004\u0002\u0000\r%3Q\n\u0005\b\u0007\u0017R\u0005\u0019AA@\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\t\u000f\u0005-%\n1\u0001\u00028\u0005\u0019bM]8n!\u0016\u00148/[:uK:$\bK]8qgR1\u0011qPB*\u0007+BqAa?L\u0001\u0004\ty\bC\u0004\u0002\f.\u0003\r!a\u000e\u0002-5\f\u0017PY3SK\u0016s7m\u001c3f!\u0006\u001c8o^8sIN$b!a \u0004\\\ru\u0003b\u0002B~\u0019\u0002\u0007\u0011q\u0010\u0005\b\u0007?b\u0005\u0019AB1\u00035\tG-\\5o5.\u001cE.[3oiB!!QSB2\u0013\u0011\u0019)Ga&\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003M1\u0018\r\\5eCR,GmS1gW\u0006\u0004&o\u001c9t)\u0019\u0011\u0019oa\u001b\u0004p!91QN'A\u0002\u0005}\u0014!\u00049s_B\u001cxJ^3se&$W\rC\u0004\u0002\f6\u0003\r!a\u000e\u0002\u0011Y\fG.\u001b3bi\u0016$b!!\u001e\u0004v\r]\u0004bBA?\u001d\u0002\u0007\u0011q\u0010\u0005\b\u0003\u0017s\u0005\u0019AA\u001c\u0003Q\u0011X-\\8wK&sg/\u00197jI\u000e{gNZ5hgR1\u0011QOB?\u0007\u007fBq!! P\u0001\u0004\ty\bC\u0004\u0002\f>\u0003\r!a\u000e\u0002!5\f\u0017PY3SK\u000e|gNZ5hkJ,G\u0003CA;\u0007\u000b\u001b9ia#\t\u000f\t\u001d\u0007\u000b1\u0001\u0003&!91\u0011\u0012)A\u0002\u00055\u0018!C8mI\u000e{gNZ5h\u0011\u001d\u0019i\t\u0015a\u0001\u0007\u001f\u000b\u0011B\\3x\u0007>tg-[41\t\rE5q\u0013\t\t\u0003\u0003\u000by-!\u0011\u0004\u0014B!1QSBL\u0019\u0001!Ab!'\u0004\f\u0006\u0005\t\u0011!B\u0001\u00077\u00131a\u0018\u00132#\u0011\u0019ija)\u0011\u0007\u0011\u001cy*C\u0002\u0004\"\u0016\u0014qAT8uQ&tw\rE\u0002e\u0007KK1aa*f\u0005\r\te._\u0001\u000fkB$\u0017\r^3e\u0007>tg-[4t)\u0019\u0019ik!0\u0004JB9Ama,\u00044\u0006E\u0015bABYK\n1A+\u001e9mKJ\u0002Da!.\u0004:B9aN!\u0001\u0002B\r]\u0006\u0003BBK\u0007s#1ba/R\u0003\u0003\u0005\tQ!\u0001\u0004\u001c\n\u0019q\f\n\u001b\t\u000f\r%\u0012\u000b1\u0001\u0004@B\"1\u0011YBc!!\t\t)a4\u0002B\r\r\u0007\u0003BBK\u0007\u000b$Aba2\u0004>\u0006\u0005\t\u0011!B\u0001\u00077\u00131a\u0018\u00133\u0011\u001d\u0019Y-\u0015a\u0001\u0007\u001b\fAbY;se\u0016tG\u000f\u0015:paN\u0004Daa4\u0004TBA\u0011\u0011QAh\u0003\u0003\u001a\t\u000e\u0005\u0003\u0004\u0016\u000eMG\u0001DBk\u0007\u0013\f\t\u0011!A\u0003\u0002\rm%aA0%g\u0005iqN^3se&$W\r\u0015:paN$b!!\u001e\u0004\\\u000eu\u0007bBA?%\u0002\u0007!Q\u0002\u0005\b\u0007[\u0012\u0006\u0019\u0001B\u0007\u0003M)\b\u000fZ1uK\u000e+(O]3oi\u000e{gNZ5h)\u0011\t)ha9\t\u000f\t}8\u000b1\u0001\u00028\u00051\u0002O]8dKN\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0005\u0004j\u000e58q^Bz!\u001d!7qVAw\u0007W\u0004b!a\u0017\u0002f\tU\u0002bBB\u0015)\u0002\u0007!1\u001d\u0005\b\u0007c$\u0006\u0019AA\u001c\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011%\u0011y\u0010\u0016I\u0001\u0002\u0004\t9$\u0001\u0011qe>\u001cWm]:SK\u000e|gNZ5hkJ\fG/[8oI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u00068fK\u0012\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0005\u00028\rmH1\u0001C\u0004\u0011\u001d\u0019iP\u0016a\u0001\u0007\u007f\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0005\u0004\u0002\u0002\u0012\u0005\u0011\u0011I\u0005\u0004i\u0006\r\u0005b\u0002C\u0003-\u0002\u0007\u0011\u0011S\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fC\u0004\u0005\nY\u0003\r!!%\u0002\u0017\u0011,G.\u001a;fI.+\u0017p]\u0001\u001eaJ|7-Z:t\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKRa\u0011Q\u000fC\b\t?!\t\u0003\"\f\u00050!9A\u0011C,A\u0002\u0011M\u0011A\u00067jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0011\t\u0011UA1D\u0007\u0003\t/QA\u0001\"\u0007\u00028\u00069a.\u001a;x_J\\\u0017\u0002\u0002C\u000f\t/\u0011a\u0003T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u0005\b\u0007\u001b;\u0006\u0019AAw\u0011\u001d!\u0019c\u0016a\u0001\tK\tQbY;ti>l7i\u001c8gS\u001e\u001c\b\u0003CAA\u0003\u001f\f\t\u0005b\n\u0011\u0007Y$I#C\u0002\u0005,]\u0014aa\u00142kK\u000e$\bbBBy/\u0002\u0007\u0011q\u0007\u0005\b\tc9\u0006\u0019AA\u001c\u0003)\u0011X\r\\8bI>sG._\u0001\u0016aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)1\t)\bb\u000e\u0005:\u0011uB1\nC(\u0011\u001d\u00119\r\u0017a\u0001\u0005KAq\u0001b\u000fY\u0001\u0004\t\t*\u0001\nva\u0012\fG/\u001a3D_:4\u0017n\u001a(b[\u0016\u001c\bb\u0002C 1\u0002\u0007A\u0011I\u0001\u000eC2dg*Z<D_:4\u0017nZ:1\t\u0011\rCq\t\t\t\u0003\u0003\u000by-!\u0011\u0005FA!1Q\u0013C$\t1!I\u0005\"\u0010\u0002\u0002\u0003\u0005)\u0011ABN\u0005\ryF%\u000e\u0005\b\t\u001bB\u0006\u0019\u0001C\u0013\u0003AqWm^\"vgR|WnQ8oM&<7\u000fC\u0004\u0004rb\u0003\r!a\u000e")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt() {
        return this.metricsReceiverPluginOpt;
    }

    private void metricsReceiverPluginOpt_$eq(Option<ClientMetricsReceiverPlugin> x$1) {
        this.metricsReceiverPluginOpt = x$1;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt, Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPluginOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        this.metricsReceiverPluginOpt_$eq(clientMetricsReceiverPluginOpt);
        zkClientOpt.foreach((Function1 & Serializable & scala.Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer.quotaManagers(), kafkaServer.config()));
        this.addBrokerReconfigurable(new BrokerDynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicProducerStateManagerConfig(kafkaServer.logManager().producerStateManagerConfig()));
        this.addBrokerReconfigurable(new DynamicRemoteLogConfig(kafkaServer));
    }

    public void addReconfigurables(ControllerServer controller) {
        Authorizer authz;
        Option<Authorizer> option = controller.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        if (!this.kafkaConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
            this.addReconfigurable((Reconfigurable)controller.kafkaYammerMetrics());
            this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().nodeId(), controller.config(), controller.metrics(), controller.clusterId()));
        }
        this.addReconfigurable(new DynamicClientQuotaCallback(controller.quotaManagers(), controller.config()));
        this.addBrokerReconfigurable(new ControllerDynamicThreadPool(controller));
        this.addBrokerReconfigurable(controller.socketServer());
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPlugin() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = this.metricsReceiverPluginOpt();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> PasswordEncoder$.MODULE$.encrypting((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return props;
    }

    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var5_5;
        void brokerReconfigurablesToUpdate2 = var6_6;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), doLog, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var6_6;
        void deletedKeySet2 = var7_7;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()), false);
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig, $this.updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().add(reconfigurable$1);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().add(reconfigurable$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().remove(reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter($this.reconfigurables()).asScala()).filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, $this.processReconfiguration$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        Option<PasswordEncoder> option;
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        if (kafkaConfig.processRoles().isEmpty()) {
            option = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
        } else {
            Option<PasswordEncoder> option2;
            option = option2;
            super((Object)PasswordEncoder$.MODULE$.noop());
        }
        this.dynamicConfigPasswordEncoder = option;
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$3) {
        x$3.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

