/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u000154Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!a\u0004A!A!\u0002\u0013i\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015CQ\u0001\u0015\u0001\u0005\u0002ECQ\u0001\u0017\u0001\u0005BeCQ!\u001a\u0001\u0005B\u0019DQA\u001b\u0001\u0005B-DQ\u0001\u001c\u0001\u0005B-\u0014A\u0002R3mCf,GMR3uG\"T!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u00031I!!\u0006\u0007\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0017A\u00029be\u0006l7\u000f\u0005\u0002\u0019I5\t\u0011D\u0003\u0002\u001b7\u0005\u0019An\\4\u000b\u0005qi\u0012!C5oi\u0016\u0014h.\u00197t\u0015\tqr$A\u0004ti>\u0014\u0018mZ3\u000b\u0005=\u0001#BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001eL!!J\r\u0003\u0017\u0019+Go\u00195QCJ\fWn]\u0001\u0015M\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0011\u0007!js&D\u0001*\u0015\tQ3&\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]%\u00121aU3r!\u0011\u0001\u0014gM\u001d\u000e\u0003-J!AM\u0016\u0003\rQ+\b\u000f\\33!\t!t'D\u00016\u0015\t1t$\u0001\u0004d_6lwN\\\u0005\u0003qU\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005MQ\u0014BA\u001e\r\u0005Q1U\r^2i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;vg\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\n?\u0013\tyDB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005M\u0011\u0015BA\"\r\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u00031\r\"k\u0015BA$,\u0005%1UO\\2uS>t\u0017\u0007E\u0002)[%\u0003B\u0001M\u00194\u0015B\u0011\u0001dS\u0005\u0003\u0019f\u0011!CR3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0011\u0001GT\u0005\u0003\u001f.\u0012A!\u00168ji\u00061A(\u001b8jiz\"bAU*U+Z;\u0006CA\n\u0001\u0011\u00151b\u00011\u0001\u0018\u0011\u00151c\u00011\u0001(\u0011\u0015ad\u00011\u0001>\u0011\u0015\u0001e\u00011\u0001B\u0011\u0015!e\u00011\u0001F\u0003!!xn\u0015;sS:<G#\u0001.\u0011\u0005m\u0013gB\u0001/a!\ti6&D\u0001_\u0015\ty\u0006#\u0001\u0004=e>|GOP\u0005\u0003C.\na\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011mK\u0001\fiJL8i\\7qY\u0016$X\rF\u0001h!\t\u0001\u0004.\u0003\u0002jW\t9!i\\8mK\u0006t\u0017\u0001D8o\u000bb\u0004\u0018N]1uS>tG#A'\u0002\u0015=t7i\\7qY\u0016$X\r")
public class DelayedFetch
extends DelayedOperation {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    public String toString() {
        return new StringBuilder(37).append("DelayedFetch(params=").append(this.params).append(", numPartitions=").append(this.fetchPartitionStatus.size()).append(")").toString();
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitionStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.params.minBytes) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    @Override
    public void onComplete() {
        Seq fetchInfos = (Seq)this.fetchPartitionStatus.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        Seq fetchPartitionData = (Seq)this.replicaManager.readFromLog(this.params, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)fetchInfos, this.quota, true).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$2._1();
                LogReadResult result = (LogReadResult)x0$2._2();
                boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(isReassignmentFetch));
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
            FetchPartitionStatus fetchStatus = (FetchPartitionStatus)x0$1._2();
            LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
            Optional fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
            try {
                LogOffsetMetadata logOffsetMetadata = fetchOffset;
                LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                if (logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2)) {
                    LogOffsetMetadata logOffsetMetadata3;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                    LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader());
                    FetchIsolation fetchIsolation = $this.params.isolation;
                    if (FetchIsolation.LOG_END.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.logEndOffset;
                    } else if (FetchIsolation.HIGH_WATERMARK.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.highWatermark;
                    } else if (FetchIsolation.TXN_COMMITTED.equals(fetchIsolation)) {
                        logOffsetMetadata3 = offsetSnapshot.lastStableOffset;
                    } else {
                        throw new MatchError((Object)fetchIsolation);
                    }
                    LogOffsetMetadata endOffset = logOffsetMetadata3;
                    if (endOffset.messageOffset != fetchOffset.messageOffset) {
                        if (endOffset.onOlderSegment(fetchOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this).append(" since it is fetching later segments of partition ").append(topicIdPartition).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (fetchOffset.onOlderSegment(endOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Satisfying fetch ").append($this).append(" immediately since it is fetching older segments.").toString());
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                            }
                        } else if (fetchOffset.messageOffset < endOffset.messageOffset) {
                            int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                accumulatedSize$1.elem += bytesAvailable;
                            }
                        }
                    }
                    fetchStatus.fetchInfo().lastFetchedEpoch.ifPresent(fetchEpoch -> {
                        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                        if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicIdPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchStatus$1.fetchInfo().fetchOffset) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this).append(" since it has diverging epoch requiring truncation for partition ").append(topicIdPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchStatus$1.fetchInfo().fetchOffset).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                    });
                }
            }
            catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (KafkaStorageException kafkaStorageException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicIdPartition).append(" is in an offline log directory, satisfy ").append($this).append(" immediately").toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (FencedLeaderEpochException fencedLeaderEpochException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicIdPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this).append(" immediately").toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            return;
        }
        throw new MatchError(null);
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, ReplicaManager replicaManager, ReplicaQuota quota, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.params = params;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.responseCallback = responseCallback;
        super(params.maxWaitMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

