/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.annotation.Annotation;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class DefaultArg
implements RestOpArg {
    private final Class<?> type;
    private final String name;
    private final ParamInfo paramInfo;

    public static DefaultArg create(ParamInfo paramInfo) {
        return new DefaultArg(paramInfo);
    }

    protected DefaultArg(ParamInfo paramInfo) {
        this.type = paramInfo.getParameterType().inner();
        this.paramInfo = paramInfo;
        this.name = this.findBeanName(paramInfo);
    }

    private String findBeanName(ParamInfo pi) {
        Annotation n = pi.getAnnotation(Annotation.class, x -> x.annotationType().getSimpleName().equals("Named"));
        if (n != null) {
            return AnnotationInfo.of((ClassInfo)null, n).getValue(String.class, "value", StringUtils.NOT_EMPTY).orElse(null);
        }
        return null;
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        return opSession.getBeanStore().getBean(this.type, this.name).orElseThrow(() -> new ArgException(this.paramInfo, "Could not resolve bean type {0}", this.type.getName()));
    }
}

