/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.http.annotation.License;

public class LicenseAnnotation {
    public static final License DEFAULT = LicenseAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(License a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends AnnotationBuilder {
        String name = "";
        String url = "";

        protected Builder() {
            super(License.class);
        }

        public License build() {
            return new Impl(this);
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }

    private static class Impl
    extends AnnotationImpl
    implements License {
        private final String name;
        private final String url;

        Impl(Builder b) {
            super(b);
            this.name = b.name;
            this.url = b.url;
            this.postConstruct();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            return this.url;
        }
    }
}

