/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import java.time.Duration;
import java.util.Properties;

public interface PrometheusConfig
extends MeterRegistryConfig {
    public static final PrometheusConfig DEFAULT = k -> null;

    @Override
    default public String prefix() {
        return "prometheus";
    }

    default public boolean descriptions() {
        return PropertyValidator.getBoolean(this, "descriptions").orElse(true);
    }

    default public Duration step() {
        return PropertyValidator.getDuration(this, "step").orElse(Duration.ofMinutes(1L));
    }

    @Nullable
    default public Properties prometheusProperties() {
        Properties properties = new Properties();
        properties.setProperty("io.prometheus.exporter.exemplarsOnAllMetricTypes", "true");
        return properties;
    }

    @Override
    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll(this, MeterRegistryConfigValidator.checkRequired("step", PrometheusConfig::step));
    }
}

