/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.compression.JZlibDecoder;
import io.netty.handler.codec.compression.JZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.SslHandler;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.Literal;
import org.apache.james.imapserver.netty.ImapLineHandlerAdapter;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.protocols.netty.LineHandlerAware;
import reactor.core.publisher.Mono;

public class NettyImapSession
implements ImapSession,
NettyConstants {
    private final Map<String, Object> attributesByKey = new HashMap<String, Object>();
    private final Encryption secure;
    private final boolean compress;
    private final Channel channel;
    private final boolean requiredSSL;
    private final boolean plainAuthEnabled;
    private final ImapSession.SessionId sessionId;
    private final boolean supportsOAuth;
    private final Optional<OidcSASLConfiguration> oidcSASLConfiguration;
    private volatile ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private final AtomicReference<SelectedMailbox> selectedMailbox = new AtomicReference();
    private volatile boolean needsCommandInjectionDetection;
    private volatile MailboxSession mailboxSession = null;

    public NettyImapSession(Channel channel, Encryption secure, boolean compress, boolean requiredSSL, boolean plainAuthEnabled, ImapSession.SessionId sessionId, Optional<OidcSASLConfiguration> oidcSASLConfiguration) {
        this.channel = channel;
        this.secure = secure;
        this.compress = compress;
        this.requiredSSL = requiredSSL;
        this.plainAuthEnabled = plainAuthEnabled;
        this.sessionId = sessionId;
        this.needsCommandInjectionDetection = true;
        this.oidcSASLConfiguration = oidcSASLConfiguration;
        this.supportsOAuth = oidcSASLConfiguration.isPresent();
    }

    public boolean needsCommandInjectionDetection() {
        return this.needsCommandInjectionDetection;
    }

    public void startDetectingCommandInjection() {
        this.needsCommandInjectionDetection = true;
    }

    public void stopDetectingCommandInjection() {
        this.needsCommandInjectionDetection = false;
    }

    public ImapSession.SessionId sessionId() {
        return this.sessionId;
    }

    public void executeSafely(Runnable runnable) {
        this.channel.eventLoop().execute(() -> {
            this.channel.config().setAutoRead(false);
            runnable.run();
            this.channel.config().setAutoRead(true);
        });
    }

    public Mono<Void> logout() {
        return this.closeMailbox().then(Mono.fromRunnable(() -> {
            this.state = ImapSessionState.LOGOUT;
        }));
    }

    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    public Mono<Void> deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        this.selectedMailbox.set(null);
        return this.closeMailbox();
    }

    public Mono<Void> selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        return this.closeMailbox().then(Mono.fromRunnable(() -> this.selectedMailbox.set(mailbox)));
    }

    public MailboxSession getMailboxSession() {
        return this.mailboxSession;
    }

    public void setMailboxSession(MailboxSession mailboxSession) {
        this.mailboxSession = mailboxSession;
    }

    public SelectedMailbox getSelected() {
        return this.selectedMailbox.get();
    }

    public ImapSessionState getState() {
        return this.state;
    }

    private Mono<Void> closeMailbox() {
        if (this.selectedMailbox.get() != null) {
            return this.selectedMailbox.get().deselect().then(Mono.fromRunnable(() -> this.selectedMailbox.set(null)));
        }
        return Mono.empty();
    }

    public Object getAttribute(String key) {
        return this.attributesByKey.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    public boolean startTLS(Runnable runnable) {
        if (!this.supportStartTLS()) {
            return false;
        }
        this.executeSafely(() -> {
            runnable.run();
            this.channel.pipeline().addFirst("sslHandler", (ChannelHandler)this.secure.sslHandler());
            this.stopDetectingCommandInjection();
        });
        return true;
    }

    public boolean supportStartTLS() {
        return this.secure != null && this.secure.supportsEncryption() && !this.isTLSActive();
    }

    public boolean isCompressionSupported() {
        return this.compress;
    }

    public boolean startCompression(Runnable runnable) {
        if (!this.isCompressionSupported()) {
            return false;
        }
        this.executeSafely(() -> {
            runnable.run();
            JZlibDecoder decoder = new JZlibDecoder(ZlibWrapper.NONE);
            JZlibEncoder encoder = new JZlibEncoder(ZlibWrapper.NONE, 5);
            if (this.channel.pipeline().get("sslHandler") == null) {
                this.channel.pipeline().addFirst("zlibDecoder", (ChannelHandler)decoder);
                this.channel.pipeline().addFirst("zlibEncoder", (ChannelHandler)encoder);
            } else {
                this.channel.pipeline().addAfter("sslHandler", "zlibDecoder", (ChannelHandler)decoder);
                this.channel.pipeline().addAfter("sslHandler", "zlibEncoder", (ChannelHandler)encoder);
            }
        });
        return true;
    }

    public void pushLineHandler(ImapLineHandler lineHandler) {
        LineHandlerAware handler = (LineHandlerAware)this.channel.pipeline().get("requestDecoder");
        handler.pushLineHandler((ChannelInboundHandlerAdapter)new ImapLineHandlerAdapter(this, lineHandler));
    }

    public void popLineHandler() {
        LineHandlerAware handler = (LineHandlerAware)this.channel.pipeline().get("requestDecoder");
        handler.popLineHandler();
    }

    public boolean isSSLRequired() {
        return this.requiredSSL;
    }

    public boolean isPlainAuthEnabled() {
        return this.plainAuthEnabled;
    }

    public boolean supportsOAuth() {
        return this.supportsOAuth;
    }

    public Optional<OidcSASLConfiguration> oidcSaslConfiguration() {
        return this.oidcSASLConfiguration;
    }

    public boolean isTLSActive() {
        return this.channel.pipeline().get("sslHandler") != null;
    }

    public Optional<SSLSession> getSSLSession() {
        return Optional.ofNullable(this.channel.pipeline().get("sslHandler")).map(SslHandler.class::cast).map(SslHandler::engine).map(SSLEngine::getSession);
    }

    public boolean supportMultipleNamespaces() {
        return false;
    }

    public boolean isCompressionActive() {
        return this.channel.pipeline().get("zlibDecoder") != null;
    }

    public void schedule(Runnable runnable, Duration waitDelay) {
        this.channel.eventLoop().schedule(runnable, waitDelay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static class EventLoopImapResponseWriter
    implements ImapResponseWriter {
        private final Channel channel;

        public EventLoopImapResponseWriter(Channel channel) {
            this.channel = channel;
        }

        public void write(byte[] buffer) {
            if (this.channel.isActive()) {
                this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])buffer));
            }
        }

        public void write(Literal literal) {
            throw new NotImplementedException();
        }
    }
}

