/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import javax.inject.Inject;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.message.view.MessageFastViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageHeaderViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageMetadataViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;

public class MetaMessageViewFactory {
    private final MessageFullViewFactory messageFullViewFactory;
    private final MessageHeaderViewFactory messageHeaderViewFactory;
    private final MessageMetadataViewFactory messageMetadataViewFactory;
    private final MessageFastViewFactory messageFastViewFactory;

    @Inject
    public MetaMessageViewFactory(MessageFullViewFactory messageFullViewFactory, MessageHeaderViewFactory messageHeaderViewFactory, MessageMetadataViewFactory messageMetadataViewFactory, MessageFastViewFactory messageFastViewFactory) {
        this.messageFullViewFactory = messageFullViewFactory;
        this.messageHeaderViewFactory = messageHeaderViewFactory;
        this.messageMetadataViewFactory = messageMetadataViewFactory;
        this.messageFastViewFactory = messageFastViewFactory;
    }

    public MessageViewFactory<? extends MessageView> getFactory(MessageProperties.ReadProfile readProfile) {
        switch (readProfile) {
            case Full: {
                return this.messageFullViewFactory;
            }
            case Header: {
                return this.messageHeaderViewFactory;
            }
            case Fast: {
                return this.messageFastViewFactory;
            }
            case Metadata: {
                return this.messageMetadataViewFactory;
            }
        }
        throw new IllegalArgumentException(readProfile + " is not a James JMAP draft supported view");
    }
}

