/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneralizedTimeMatchingRule
extends MatchingRule {
    @NotNull
    private static final GeneralizedTimeMatchingRule INSTANCE = new GeneralizedTimeMatchingRule();
    @NotNull
    private static final String GENERALIZED_TIME_DATE_FORMAT = "yyyyMMddHHmmss.SSS'Z'";
    @NotNull
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    @NotNull
    public static final String EQUALITY_RULE_NAME = "generalizedTimeMatch";
    @NotNull
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("generalizedTimeMatch");
    @NotNull
    public static final String EQUALITY_RULE_OID = "2.5.13.27";
    @NotNull
    public static final String ORDERING_RULE_NAME = "generalizedTimeOrderingMatch";
    @NotNull
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("generalizedTimeOrderingMatch");
    @NotNull
    public static final String ORDERING_RULE_OID = "2.5.13.28";
    private static final long serialVersionUID = -6317451154598148593L;
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();

    @NotNull
    public static GeneralizedTimeMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    @NotNull
    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    @Override
    @NotNull
    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleOID() {
        return null;
    }

    @Override
    public boolean valuesMatch(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        Date d2;
        Date d1;
        try {
            d1 = StaticUtils.decodeGeneralizedTime(value1.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        try {
            d2 = StaticUtils.decodeGeneralizedTime(value2.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        return d1.equals(d2);
    }

    @Override
    public boolean matchesAnyValue(@NotNull ASN1OctetString assertionValue, @NotNull ASN1OctetString[] attributeValues) throws LDAPException {
        Date assertionValueDate;
        if (assertionValue == null || attributeValues == null || attributeValues.length == 0) {
            return false;
        }
        try {
            assertionValueDate = StaticUtils.decodeGeneralizedTime(assertionValue.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        for (ASN1OctetString attributeValue : attributeValues) {
            try {
                if (!assertionValueDate.equals(StaticUtils.decodeGeneralizedTime(attributeValue.stringValue()))) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    @Override
    public boolean matchesSubstring(@NotNull ASN1OctetString value, @Nullable ASN1OctetString subInitial, @Nullable ASN1OctetString[] subAny, @Nullable ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_GENERALIZED_TIME_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        Date d2;
        Date d1;
        try {
            d1 = StaticUtils.decodeGeneralizedTime(value1.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        try {
            d2 = StaticUtils.decodeGeneralizedTime(value2.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        return d1.compareTo(d2);
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        Date d;
        try {
            d = StaticUtils.decodeGeneralizedTime(value.stringValue());
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(pe.getMessage()), pe);
        }
        SimpleDateFormat f = dateFormat.get();
        if (f == null) {
            f = new SimpleDateFormat(GENERALIZED_TIME_DATE_FORMAT);
            f.setTimeZone(UTC_TIME_ZONE);
            dateFormat.set(f);
        }
        return new ASN1OctetString(f.format(d));
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_GENERALIZED_TIME_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

