/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt;

import com.github.fge.lambdas.Throwing;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ForwardUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    private final RecipientRewriteTable rrt;

    @Inject
    public ForwardUsernameChangeTaskStep(RecipientRewriteTable rrt) {
        this.rrt = rrt;
    }

    @Override
    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        MappingSource oldSource = MappingSource.fromUser(oldUsername);
        MappingSource newSource = MappingSource.fromUser(newUsername);
        return this.migrateExistingForwards(oldSource, newSource).then(this.redirectMailsToTheNewUsername(newUsername, oldSource)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Mono<Void> redirectMailsToTheNewUsername(Username newUsername, MappingSource oldSource) {
        return Mono.fromRunnable(Throwing.runnable(() -> this.rrt.addForwardMapping(oldSource, newUsername.asString())));
    }

    private Mono<Void> migrateExistingForwards(MappingSource oldSource, MappingSource newSource) {
        return Mono.fromCallable(() -> this.rrt.getStoredMappings(oldSource)).flatMapMany(mappings -> Flux.fromStream(mappings.asStream())).filter(mapping -> mapping.getType().equals((Object)Mapping.Type.Forward)).concatMap(mapping -> this.migrateExistingForward(oldSource, newSource, (Mapping)mapping)).then();
    }

    private Mono<Object> migrateExistingForward(MappingSource oldSource, MappingSource newSource, Mapping mapping) {
        if (mapping.getType().equals((Object)Mapping.Type.Forward) && mapping.getMappingValue().equals(oldSource.asString())) {
            return Mono.fromRunnable(Throwing.runnable(() -> this.rrt.addForwardMapping(newSource, newSource.asString()))).then(Mono.fromRunnable(Throwing.runnable(() -> this.rrt.removeMapping(oldSource, mapping))));
        }
        return Mono.fromRunnable(Throwing.runnable(() -> this.rrt.addForwardMapping(newSource, mapping.getMappingValue()))).then(Mono.fromRunnable(Throwing.runnable(() -> this.rrt.removeMapping(oldSource, mapping))));
    }

    @Override
    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("ForwardUsernameChangeTaskStep");
    }

    @Override
    public int priority() {
        return 0;
    }
}

