/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BodyOffsetInputStream
extends InputStream {
    private long count = 0L;
    private long bodyStartOctet = -1L;
    private final PushbackInputStream in;
    private long readBytes = 0L;

    public BodyOffsetInputStream(InputStream in) {
        this.in = new PushbackInputStream(in, 3);
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        if (i != -1) {
            ++this.readBytes;
            if (this.bodyStartOctet == -1L && i == 13) {
                int a = this.in.read();
                if (a == 10) {
                    int b = this.in.read();
                    if (b == 13) {
                        int c = this.in.read();
                        if (c == 10) {
                            this.bodyStartOctet = this.count + 4L;
                        }
                        this.in.unread(c);
                    }
                    this.in.unread(b);
                }
                this.in.unread(a);
            }
            ++this.count;
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bodyStartOctet == -1L) {
            return super.read(b, off, len);
        }
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.readBytes += (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.bodyStartOctet == -1L) {
            return super.read(b);
        }
        int r = this.in.read(b);
        if (r != -1) {
            this.readBytes += (long)r;
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        long i = 0L;
        while (i++ < n && this.read() != -1) {
        }
        return i;
    }

    public long getBodyStartOffset() {
        return this.bodyStartOctet;
    }

    public long getReadBytes() {
        return this.readBytes;
    }
}

