/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class OpenJPAMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Move, MailboxManager.MailboxCapabilities.Annotation);

    @Inject
    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, SessionProvider sessionProvider, MessageParser messageParser, MessageId.Factory messageIdFactory, EventBus eventBus, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex index, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm) {
        super((MailboxSessionMapperFactory)mapperFactory, sessionProvider, (MailboxPathLocker)new JVMMailboxPathLocker(), messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, eventBus, storeRightManager, quotaComponents, index, MailboxManagerConfiguration.DEFAULT, PreDeletionHooks.NO_PRE_DELETION_HOOK, threadIdGuessingAlgorithm);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) {
        return new OpenJPAMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailboxRow, this.getQuotaComponents().getQuotaManager(), this.getQuotaComponents().getQuotaRootResolver(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.getThreadIdGuessingAlgorithm());
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }
}

