/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.identity;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdate;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.IdentityId$;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\u0006\r\u0001eAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004I\u0001\u0001\u0006I!\f\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u0013\u0002!\t\u0005\u0017\u0005\u0006;\u0002!\tE\u0018\u0005\u0006A\u0002!\t%\u0019\u0005\u0006]\u0002!\te\u001c\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0005]iU-\\8ss\u000e+8\u000f^8n\u0013\u0012,g\u000e^5us\u0012\u000buJ\u0003\u0002\u000e\u001d\u0005A\u0011\u000eZ3oi&$\u0018P\u0003\u0002\u0010!\u00051Q.Z7pefT!!\u0005\n\u0002\t)l\u0017\r\u001d\u0006\u0003'Q\tQA[1nKNT!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!I\u0013\u000e\u0003\tR!!D\u0012\u000b\u0005\u0011\u0002\u0012aA1qS&\u0011aE\t\u0002\u0012\u0007V\u001cHo\\7JI\u0016tG/\u001b;z\t\u0006{\u0015A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\r\u0003\u0015!\u0018M\u00197f+\u0005i\u0003#\u0002\u00188s}*U\"A\u0018\u000b\u0005A\n\u0014aB2pY2,7\r\u001e\u0006\u0003eM\naaY8n[>t'B\u0001\u001b6\u0003\u00199wn\\4mK*\ta'A\u0002d_6L!\u0001O\u0018\u0003\u000bQ\u000b'\r\\3\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0012\u0001B2pe\u0016L!AP\u001e\u0003\u0011U\u001bXM\u001d8b[\u0016\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0012\u0002\u000b5|G-\u001a7\n\u0005\u0011\u000b%AC%eK:$\u0018\u000e^=JIB\u0011\u0001IR\u0005\u0003\u000f\u0006\u0013\u0001\"\u00133f]RLG/_\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\tM\fg/\u001a\u000b\u0004\u0017F\u001b\u0006c\u0001'P\u000b6\tQJ\u0003\u0002O-\u0005y!/Z1di&4Xm\u001d;sK\u0006l7/\u0003\u0002Q\u001b\nI\u0001+\u001e2mSNDWM\u001d\u0005\u0006%\u0012\u0001\r!O\u0001\u0005kN,'\u000fC\u0003U\t\u0001\u0007Q+A\bde\u0016\fG/[8o%\u0016\fX/Z:u!\t\tc+\u0003\u0002XE\t9\u0012\nZ3oi&$\u0018p\u0011:fCRLwN\u001c*fcV,7\u000f\u001e\u000b\u0005\u0017fSF\fC\u0003S\u000b\u0001\u0007\u0011\bC\u0003\\\u000b\u0001\u0007q(\u0001\u0006jI\u0016tG/\u001b;z\u0013\u0012DQ\u0001V\u0003A\u0002U\u000bA\u0001\\5tiR\u00111j\u0018\u0005\u0006%\u001a\u0001\r!O\u0001\u0011M&tGMQ=JI\u0016tG/\u001b;z\u0013\u0012$2A\u00197n!\r\u0019'.R\u0007\u0002I*\u0011QMZ\u0001\naV\u0014G.[:iKJT!!H4\u000b\u0005qB'\"A5\u0002\u000fI,\u0017m\u0019;pe&\u00111\u000e\u001a\u0002\u0006'6{gn\u001c\u0005\u0006%\u001e\u0001\r!\u000f\u0005\u00067\u001e\u0001\raP\u0001\u0007kB$\u0017\r^3\u0015\tA$XO\u001e\t\u0004\u0019>\u000b\bCA\u000es\u0013\t\u0019HD\u0001\u0003V]&$\b\"\u0002*\t\u0001\u0004I\u0004\"B.\t\u0001\u0004y\u0004\"B<\t\u0001\u0004A\u0018AD5eK:$\u0018\u000e^=Va\u0012\fG/\u001a\t\u0003CeL!A\u001f\u0012\u0003\u001d%#WM\u001c;jif,\u0006\u000fZ1uK\u00061Q\u000f]:feR$2! @\u0000!\r\u0019'.\u001d\u0005\u0006%&\u0001\r!\u000f\u0005\u0007\u0003\u0003I\u0001\u0019A#\u0002\u000bA\fGo\u00195\u0002\r\u0011,G.\u001a;f)\u0015\u0001\u0018qAA\u0006\u0011\u0019\tIA\u0003a\u0001s\u0005AQo]3s]\u0006lW\rC\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u0007%$7\u000fE\u0003\u0002\u0012\u0005\u0005rH\u0004\u0003\u0002\u0014\u0005ua\u0002BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e\u0001$\u0001\u0004=e>|GOP\u0005\u0002;%\u0019\u0011q\u0004\u000f\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005\r\u0019V-\u001d\u0006\u0004\u0003?a\u0002")
public class MemoryCustomIdentityDAO
implements CustomIdentityDAO {
    private final Table<Username, IdentityId, Identity> table = HashBasedTable.create();

    private Table<Username, IdentityId, Identity> table() {
        return this.table;
    }

    @Override
    public Publisher<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.save(user, IdentityId$.MODULE$.generate(), creationRequest);
    }

    @Override
    public Publisher<Identity> save(Username user, IdentityId identityId, IdentityCreationRequest creationRequest) {
        return SMono$.MODULE$.just((Object)identityId).map((Function1 & Serializable)id -> creationRequest.asIdentity((IdentityId)id)).doOnNext((Function1 & Serializable)identity -> {
            MemoryCustomIdentityDAO.$anonfun$save$2(this, user, identity);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Publisher<Identity> list(Username user) {
        return SFlux$.MODULE$.fromIterable(CollectionConverters$.MODULE$.CollectionHasAsScala(this.table().row((Object)user).values()).asScala());
    }

    @Override
    public SMono<Identity> findByIdentityId(Username user, IdentityId identityId) {
        return SFlux$.MODULE$.fromIterable(CollectionConverters$.MODULE$.CollectionHasAsScala(this.table().row((Object)user).values()).asScala()).filter((Function1 & Serializable)identity -> BoxesRunTime.boxToBoolean((boolean)MemoryCustomIdentityDAO.$anonfun$findByIdentityId$1(identityId, identity))).next();
    }

    @Override
    public Publisher<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdate identityUpdate) {
        return (Publisher)Option$.MODULE$.apply(this.table().get((Object)user, (Object)identityId)).map((Function1 & Serializable)identity -> identityUpdate.update((Identity)identity)).fold((Function0 & Serializable)() -> SMono$.MODULE$.error((Throwable)new IdentityNotFoundException(identityId)), (Function1 & Serializable)identity -> SMono$.MODULE$.fromCallable(() -> {
            MemoryCustomIdentityDAO.$anonfun$update$4(this, user, identityId, identity);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public SMono<BoxedUnit> upsert(Username user, Identity patch) {
        return SMono$.MODULE$.fromCallable(() -> {
            MemoryCustomIdentityDAO.$anonfun$upsert$1(this, user, patch);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Publisher<BoxedUnit> delete(Username username, Seq<IdentityId> ids) {
        return SFlux$.MODULE$.fromIterable(ids).doOnNext((Function1 & Serializable)id -> {
            MemoryCustomIdentityDAO.$anonfun$delete$1(this, username, id);
            return BoxedUnit.UNIT;
        }).then();
    }

    public static final /* synthetic */ void $anonfun$save$2(MemoryCustomIdentityDAO $this, Username user$1, Identity identity) {
        $this.table().put((Object)user$1, (Object)identity.id(), (Object)identity);
    }

    public static final /* synthetic */ boolean $anonfun$findByIdentityId$1(IdentityId identityId$1, Identity identity) {
        return identity.id().equals(identityId$1);
    }

    public static final /* synthetic */ void $anonfun$update$4(MemoryCustomIdentityDAO $this, Username user$2, IdentityId identityId$2, Identity identity$1) {
        $this.table().put((Object)user$2, (Object)identityId$2, (Object)identity$1);
    }

    public static final /* synthetic */ void $anonfun$upsert$1(MemoryCustomIdentityDAO $this, Username user$3, Identity patch$1) {
        $this.table().put((Object)user$3, (Object)patch$1.id(), (Object)patch$1);
    }

    public static final /* synthetic */ void $anonfun$delete$1(MemoryCustomIdentityDAO $this, Username username$1, IdentityId id) {
        $this.table().remove((Object)username$1, (Object)id);
    }
}

