/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.subscribers;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.events.QuotaThresholdChangedEvent;
import org.apache.james.mailbox.quota.mailing.subscribers.QuotaThresholdNotice;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.MailetContext;

public class QuotaThresholdMailer
implements Subscriber {
    private final MailetContext mailetContext;
    private final UsersRepository usersRepository;
    private final FileSystem fileSystem;
    private final QuotaMailingListenerConfiguration configuration;

    public QuotaThresholdMailer(MailetContext mailetContext, UsersRepository usersRepository, FileSystem fileSystem, QuotaMailingListenerConfiguration configuration) {
        this.mailetContext = mailetContext;
        this.usersRepository = usersRepository;
        this.fileSystem = fileSystem;
        this.configuration = configuration;
    }

    public void handle(Event event) {
        if (event instanceof QuotaThresholdChangedEvent) {
            this.handleEvent((QuotaThresholdChangedEvent)event);
        }
    }

    private void handleEvent(QuotaThresholdChangedEvent event) {
        Optional<QuotaThresholdNotice> maybeNotice = QuotaThresholdNotice.builder().countQuota(event.getCountQuota()).sizeQuota(event.getSizeQuota()).countThreshold(event.getCountHistoryEvolution()).sizeThreshold(event.getSizeHistoryEvolution()).withConfiguration(this.configuration).build();
        maybeNotice.ifPresent((Consumer<QuotaThresholdNotice>)Throwing.consumer(notice -> this.sendNotice((QuotaThresholdNotice)notice, event.getAggregateId().getUsername())));
    }

    private void sendNotice(QuotaThresholdNotice notice, Username username) throws UsersRepositoryException, MessagingException, IOException {
        MailAddress sender = this.mailetContext.getPostmaster();
        MailAddress recipient = this.usersRepository.getMailAddressFor(username);
        this.mailetContext.sendMail(sender, (Collection)ImmutableList.of((Object)recipient), notice.generateMimeMessage(this.fileSystem).addToRecipient(recipient.asString()).addFrom(sender.asString()).build());
    }
}

