/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.security.Provider;
import java.security.Security;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.JMAPRoutesHandler;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.Version;
import org.apache.james.jmap.draft.JMAPModule;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.jmap.draft.MessageIdProbe;
import org.apache.james.jmap.draft.crypto.JamesSignatureHandler;
import org.apache.james.jmap.http.AuthenticationRoutes;
import org.apache.james.jmap.http.DownloadRoutes;
import org.apache.james.jmap.http.JMAPApiRoutes;
import org.apache.james.jmap.http.UploadRoutes;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JMAPServerModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new JMAPModule());
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(JmapGuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(MessageIdProbe.class);
    }

    @ProvidesIntoSet
    InitializationOperation startJmap(JMAPServer server, JamesSignatureHandler signatureHandler, JMAPConfiguration jmapConfiguration) {
        return InitilizationOperationBuilder.forClass(JMAPServer.class).init(() -> {
            if (jmapConfiguration.isEnabled()) {
                signatureHandler.init();
                server.start();
                this.registerPEMWithSecurityProvider();
            }
        });
    }

    @ProvidesIntoSet
    JMAPRoutesHandler routesHandler(AuthenticationRoutes authenticationRoutes, JMAPApiRoutes jmapApiRoutes, UploadRoutes uploadRoutes, DownloadRoutes downloadRoutes) {
        return new JMAPRoutesHandler(Version.DRAFT, new JMAPRoutes[]{authenticationRoutes, jmapApiRoutes, uploadRoutes, downloadRoutes});
    }

    private void registerPEMWithSecurityProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

