/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.fge.lambdas.Throwing;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.events.Group;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEventDeadLettersGroupDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;

    @Inject
    CassandraEventDeadLettersGroupDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = this.prepareInsertStatement(session);
        this.selectAllStatement = this.prepareSelectStatement(session);
    }

    private PreparedStatement prepareInsertStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"group_table").value("group", (Object)QueryBuilder.bindMarker((String)"group")));
    }

    private PreparedStatement prepareSelectStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"group"}).from("group_table"));
    }

    Mono<Void> storeGroup(Group group) {
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setString("group", group.asString()));
    }

    Flux<Group> retrieveAllGroups() {
        return this.executor.executeRows((Statement)this.selectAllStatement.bind()).map((Function)Throwing.function(row -> Group.deserialize((String)row.getString("group"))));
    }
}

