/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.math.BigDecimal;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsonParserSettings;
import play.api.libs.json.JsonValidationError$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class BigDecimalParser$ {
    public static final BigDecimalParser$ MODULE$ = new BigDecimalParser$();

    public JsResult<BigDecimal> parse(String input, JsonParserSettings settings) {
        JsResult<Nothing$> jsResult;
        block5: {
            if (input.length() > settings.bigDecimalParseSettings().digitsLimit()) {
                jsResult = JsError$.MODULE$.apply("error.expected.numberdigitlimit");
            } else {
                try {
                    BigDecimal bigDecimal = new BigDecimal(input, settings.bigDecimalParseSettings().mathContext());
                    int scale = bigDecimal.scale();
                    if (Math.abs(scale) > settings.bigDecimalParseSettings().scaleLimit()) {
                        jsResult = JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.numberscalelimit", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)scale)})));
                        break block5;
                    }
                    jsResult = new JsSuccess<BigDecimal>(bigDecimal, JsSuccess$.MODULE$.apply$default$2());
                }
                catch (NumberFormatException numberFormatException) {
                    jsResult = JsError$.MODULE$.apply("error.expected.numberformatexception");
                }
            }
        }
        return jsResult;
    }

    private BigDecimalParser$() {
    }
}

