/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.activemq.FileSystemBlobTransferPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedActiveMQ {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedActiveMQ.class);
    private static final String KAHADB_STORE_LOCATION = "file://var/store/activemq/brokers/KahaDB";
    private static final String BLOB_TRANSFER_LOCATION = "file://var/store/activemq/blob-transfer";
    private static final String BROCKERS_LOCATION = "file://var/store/activemq/brokers";
    private static final String BROKER_ID = "broker";
    private static final String BROKER_NAME = "james";
    private static final String BROCKER_URI = "tcp://localhost:0";
    private final ActiveMQConnectionFactory activeMQConnectionFactory;
    private final PersistenceAdapter persistenceAdapter;
    private BrokerService brokerService;

    @Inject
    private EmbeddedActiveMQ(FileSystem fileSystem, PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
        try {
            persistenceAdapter.setDirectory(fileSystem.getFile(KAHADB_STORE_LOCATION));
            this.launchEmbeddedBroker(fileSystem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.activeMQConnectionFactory = this.createActiveMQConnectionFactory(this.createBlobTransferPolicy(fileSystem));
    }

    public ConnectionFactory getConnectionFactory() {
        return this.activeMQConnectionFactory;
    }

    @PreDestroy
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    private ActiveMQConnectionFactory createActiveMQConnectionFactory(BlobTransferPolicy blobTransferPolicy) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://james?create=false");
        connectionFactory.setTrustAllPackages(false);
        connectionFactory.setBlobTransferPolicy(blobTransferPolicy);
        connectionFactory.setPrefetchPolicy(this.createActiveMQPrefetchPolicy());
        return connectionFactory;
    }

    private ActiveMQPrefetchPolicy createActiveMQPrefetchPolicy() {
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        prefetchPolicy.setTopicPrefetch(0);
        return prefetchPolicy;
    }

    private BlobTransferPolicy createBlobTransferPolicy(FileSystem fileSystem) {
        FileSystemBlobTransferPolicy blobTransferPolicy = new FileSystemBlobTransferPolicy();
        blobTransferPolicy.setDefaultUploadUrl(BLOB_TRANSFER_LOCATION);
        blobTransferPolicy.setFileSystem(fileSystem);
        return blobTransferPolicy;
    }

    private void launchEmbeddedBroker(FileSystem fileSystem) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setBrokerName(BROKER_NAME);
        this.brokerService.setUseJmx(false);
        this.brokerService.setPersistent(true);
        this.brokerService.setDataDirectoryFile(fileSystem.getFile(BROCKERS_LOCATION));
        this.brokerService.setUseShutdownHook(false);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setBrokerId(BROKER_ID);
        String[] uris = new String[]{BROCKER_URI};
        this.brokerService.setTransportConnectorURIs(uris);
        ManagementContext managementContext = new ManagementContext();
        managementContext.setCreateConnector(false);
        this.brokerService.setManagementContext(managementContext);
        this.brokerService.setPersistenceAdapter(this.persistenceAdapter);
        BrokerPlugin[] brokerPlugins = new BrokerPlugin[]{new StatisticsBrokerPlugin()};
        this.brokerService.setPlugins(brokerPlugins);
        String[] transportConnectorsURIs = new String[]{BROCKER_URI};
        this.brokerService.setTransportConnectorURIs(transportConnectorsURIs);
        this.brokerService.start();
        LOGGER.info("Started embedded activeMq");
    }
}

