/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.mailbox.model.QuotaRoot;

public class Quotas {
    private final Map<QuotaId, Quota> quotas;

    public static Quotas from(ImmutableMap<QuotaId, Quota> quotas) {
        return new Quotas(quotas);
    }

    public static Quotas from(QuotaId quotaId, Quota quota) {
        return new Quotas((ImmutableMap<QuotaId, Quota>)ImmutableMap.of((Object)quotaId, (Object)quota));
    }

    private Quotas(ImmutableMap<QuotaId, Quota> quotas) {
        this.quotas = quotas;
    }

    @JsonValue
    public Map<QuotaId, Quota> getQuotas() {
        return this.quotas;
    }

    public static class Value<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> {
        private final Number used;
        private final Optional<Number> max;

        public Value(Number used, Optional<Number> max) {
            this.used = used;
            this.max = max;
        }

        public Number getUsed() {
            return this.used;
        }

        public Optional<Number> getMax() {
            return this.max;
        }
    }

    public static enum Type {
        STORAGE,
        MESSAGE;

    }

    public static class Quota {
        private final Map<Type, Value<?, ?>> quota;

        public static Quota from(ImmutableMap<Type, Value<?, ?>> quota) {
            return new Quota(quota);
        }

        public static Quota from(Value<QuotaSizeLimit, QuotaSizeUsage> storage, Value<QuotaCountLimit, QuotaCountUsage> message) {
            return new Quota(ImmutableMap.of((Object)((Object)Type.STORAGE), storage, (Object)((Object)Type.MESSAGE), message));
        }

        private Quota(ImmutableMap<Type, Value<?, ?>> quota) {
            this.quota = quota;
        }

        @JsonValue
        public Map<Type, Value<?, ?>> getQuota() {
            return this.quota;
        }
    }

    public static class QuotaId {
        private final QuotaRoot quotaRoot;

        public static QuotaId fromQuotaRoot(QuotaRoot quotaRoot) {
            return new QuotaId(quotaRoot);
        }

        private QuotaId(QuotaRoot quotaRoot) {
            this.quotaRoot = quotaRoot;
        }

        @JsonValue
        public String getName() {
            return this.quotaRoot.getValue();
        }

        public final boolean equals(Object o) {
            if (o instanceof QuotaId) {
                QuotaId other = (QuotaId)o;
                return Objects.equals(this.quotaRoot, other.quotaRoot);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.quotaRoot);
        }
    }
}

