/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Property;

public enum MailboxProperty implements Property
{
    ID("id"),
    NAME("name"),
    PARENT_ID("parentId"),
    ROLE("role"),
    SORT_ORDER("sortOrder"),
    MUST_BE_ONLY_MAILBOX("mustBeOnlyMailbox"),
    MAY_READ_ITEMS("mayReadItems"),
    MAY_ADD_ITEMS("mayAddItems"),
    MAY_REMOVE_ITEMS("mayRemoveItems"),
    MAY_CREATE_CHILD("mayCreateChild"),
    MAY_RENAME("mayRename"),
    MAY_DELETE("mayDelete"),
    TOTAL_MESSAGES("totalMessages"),
    UNREAD_MESSAGES("unreadMessages"),
    TOTAL_THREADS("totalThreads"),
    UNREAD_THREADS("unreadThreads");

    private final String fieldName;

    private MailboxProperty(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String asFieldName() {
        return this.fieldName;
    }

    public static Optional<MailboxProperty> findProperty(String value) {
        Preconditions.checkNotNull((Object)value);
        return Arrays.stream(MailboxProperty.values()).filter(element -> element.fieldName.equals(value)).findAny();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this.fieldName).toString();
    }
}

