/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger LOG = LoggerFactory.getLogger(Response.class);
    private HttpServletResponse response;
    private String body;

    protected Response() {
    }

    Response(HttpServletResponse response) {
        this.response = response;
    }

    public void status(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public int status() {
        return this.response.getStatus();
    }

    public void type(String contentType) {
        this.response.setContentType(contentType);
    }

    public String type() {
        return this.response.getContentType();
    }

    public void body(String body) {
        this.body = body;
    }

    public String body() {
        return this.body;
    }

    public HttpServletResponse raw() {
        return this.response;
    }

    public void redirect(String location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting ({} {} to {}", new Object[]{"Found", 302, location});
        }
        try {
            this.response.sendRedirect(location);
        }
        catch (IOException ioException) {
            LOG.warn("Redirect failure", (Throwable)ioException);
        }
    }

    public void redirect(String location, int httpStatusCode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting ({} to {}", (Object)httpStatusCode, (Object)location);
        }
        this.response.setStatus(httpStatusCode);
        this.response.setHeader("Location", location);
        this.response.setHeader("Connection", "close");
        try {
            this.response.sendError(httpStatusCode);
        }
        catch (IOException e) {
            LOG.warn("Exception when trying to redirect permanently", (Throwable)e);
        }
    }

    public void header(String header, String value) {
        this.response.addHeader(header, value);
    }

    public void header(String header, int value) {
        this.response.addIntHeader(header, value);
    }

    public void header(String header, Date value) {
        this.response.addDateHeader(header, value.getTime());
    }

    public void header(String header, java.sql.Date value) {
        this.response.addDateHeader(header, value.getTime());
    }

    public void header(String header, Instant value) {
        this.response.addDateHeader(header, value.toEpochMilli());
    }

    public void cookie(String name, String value) {
        this.cookie(name, value, -1, false);
    }

    public void cookie(String name, String value, int maxAge) {
        this.cookie(name, value, maxAge, false);
    }

    public void cookie(String name, String value, int maxAge, boolean secured) {
        this.cookie(name, value, maxAge, secured, false);
    }

    public void cookie(String name, String value, int maxAge, boolean secured, boolean httpOnly) {
        this.cookie("", "", name, value, maxAge, secured, httpOnly);
    }

    public void cookie(String path, String name, String value, int maxAge, boolean secured) {
        this.cookie("", path, name, value, maxAge, secured, false);
    }

    public void cookie(String path, String name, String value, int maxAge, boolean secured, boolean httpOnly) {
        this.cookie("", path, name, value, maxAge, secured, httpOnly);
    }

    public void cookie(String domain, String path, String name, String value, int maxAge, boolean secured, boolean httpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secured);
        cookie.setHttpOnly(httpOnly);
        this.response.addCookie(cookie);
    }

    public void removeCookie(String name) {
        this.removeCookie(null, name);
    }

    public void removeCookie(String path, String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setPath(path);
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
    }
}

