/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowSpecification;

public class WindowDefinition
extends Node {
    private final Identifier name;
    private final WindowSpecification window;

    public WindowDefinition(NodeLocation location, Identifier name, WindowSpecification window) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Objects.requireNonNull(window, "window is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public WindowSpecification getWindow() {
        return this.window;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowDefinition(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.window);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowDefinition o = (WindowDefinition)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.window);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("window", (Object)this.window).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WindowDefinition.sameClass(this, other)) {
            return false;
        }
        return this.name.equals(((WindowDefinition)other).name);
    }
}

