/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowseDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=514");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=516");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=515");
    private final NodeId nodeId;
    private final BrowseDirection browseDirection;
    private final NodeId referenceTypeId;
    private final Boolean includeSubtypes;
    private final UInteger nodeClassMask;
    private final UInteger resultMask;

    public BrowseDescription(NodeId nodeId, BrowseDirection browseDirection, NodeId referenceTypeId, Boolean includeSubtypes, UInteger nodeClassMask, UInteger resultMask) {
        this.nodeId = nodeId;
        this.browseDirection = browseDirection;
        this.referenceTypeId = referenceTypeId;
        this.includeSubtypes = includeSubtypes;
        this.nodeClassMask = nodeClassMask;
        this.resultMask = resultMask;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public BrowseDirection getBrowseDirection() {
        return this.browseDirection;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public UInteger getNodeClassMask() {
        return this.nodeClassMask;
    }

    public UInteger getResultMask() {
        return this.resultMask;
    }

    protected BrowseDescription(BrowseDescriptionBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((BrowseDescriptionBuilder)b).nodeId;
        this.browseDirection = ((BrowseDescriptionBuilder)b).browseDirection;
        this.referenceTypeId = ((BrowseDescriptionBuilder)b).referenceTypeId;
        this.includeSubtypes = ((BrowseDescriptionBuilder)b).includeSubtypes;
        this.nodeClassMask = ((BrowseDescriptionBuilder)b).nodeClassMask;
        this.resultMask = ((BrowseDescriptionBuilder)b).resultMask;
    }

    public static BrowseDescriptionBuilder<?, ?> builder() {
        return new BrowseDescriptionBuilderImpl();
    }

    public BrowseDescriptionBuilder<?, ?> toBuilder() {
        return new BrowseDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowseDescription)) {
            return false;
        }
        BrowseDescription other = (BrowseDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$includeSubtypes = this.getIncludeSubtypes();
        Boolean other$includeSubtypes = other.getIncludeSubtypes();
        if (this$includeSubtypes == null ? other$includeSubtypes != null : !((Object)this$includeSubtypes).equals(other$includeSubtypes)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        BrowseDirection this$browseDirection = this.getBrowseDirection();
        BrowseDirection other$browseDirection = other.getBrowseDirection();
        if (this$browseDirection == null ? other$browseDirection != null : !this$browseDirection.equals(other$browseDirection)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        UInteger this$nodeClassMask = this.getNodeClassMask();
        UInteger other$nodeClassMask = other.getNodeClassMask();
        if (this$nodeClassMask == null ? other$nodeClassMask != null : !((Object)this$nodeClassMask).equals(other$nodeClassMask)) {
            return false;
        }
        UInteger this$resultMask = this.getResultMask();
        UInteger other$resultMask = other.getResultMask();
        return !(this$resultMask == null ? other$resultMask != null : !((Object)this$resultMask).equals(other$resultMask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowseDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeSubtypes = this.getIncludeSubtypes();
        result = result * 59 + ($includeSubtypes == null ? 43 : ((Object)$includeSubtypes).hashCode());
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        BrowseDirection $browseDirection = this.getBrowseDirection();
        result = result * 59 + ($browseDirection == null ? 43 : $browseDirection.hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        UInteger $nodeClassMask = this.getNodeClassMask();
        result = result * 59 + ($nodeClassMask == null ? 43 : ((Object)$nodeClassMask).hashCode());
        UInteger $resultMask = this.getResultMask();
        result = result * 59 + ($resultMask == null ? 43 : ((Object)$resultMask).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BrowseDescription(nodeId=" + this.getNodeId() + ", browseDirection=" + this.getBrowseDirection() + ", referenceTypeId=" + this.getReferenceTypeId() + ", includeSubtypes=" + this.getIncludeSubtypes() + ", nodeClassMask=" + this.getNodeClassMask() + ", resultMask=" + this.getResultMask() + ")";
    }

    private static final class BrowseDescriptionBuilderImpl
    extends BrowseDescriptionBuilder<BrowseDescription, BrowseDescriptionBuilderImpl> {
        private BrowseDescriptionBuilderImpl() {
        }

        @Override
        protected BrowseDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public BrowseDescription build() {
            return new BrowseDescription(this);
        }
    }

    public static abstract class BrowseDescriptionBuilder<C extends BrowseDescription, B extends BrowseDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private BrowseDirection browseDirection;
        private NodeId referenceTypeId;
        private Boolean includeSubtypes;
        private UInteger nodeClassMask;
        private UInteger resultMask;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowseDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowseDescription instance, BrowseDescriptionBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.browseDirection(instance.browseDirection);
            b.referenceTypeId(instance.referenceTypeId);
            b.includeSubtypes(instance.includeSubtypes);
            b.nodeClassMask(instance.nodeClassMask);
            b.resultMask(instance.resultMask);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B browseDirection(BrowseDirection browseDirection) {
            this.browseDirection = browseDirection;
            return (B)this.self();
        }

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B includeSubtypes(Boolean includeSubtypes) {
            this.includeSubtypes = includeSubtypes;
            return (B)this.self();
        }

        public B nodeClassMask(UInteger nodeClassMask) {
            this.nodeClassMask = nodeClassMask;
            return (B)this.self();
        }

        public B resultMask(UInteger resultMask) {
            this.resultMask = resultMask;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowseDescription.BrowseDescriptionBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", browseDirection=" + this.browseDirection + ", referenceTypeId=" + this.referenceTypeId + ", includeSubtypes=" + this.includeSubtypes + ", nodeClassMask=" + this.nodeClassMask + ", resultMask=" + this.resultMask + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowseDescription> {
        @Override
        public Class<BrowseDescription> getType() {
            return BrowseDescription.class;
        }

        @Override
        public BrowseDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            BrowseDirection browseDirection = decoder.readEnum("BrowseDirection", BrowseDirection.class);
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean includeSubtypes = decoder.readBoolean("IncludeSubtypes");
            UInteger nodeClassMask = decoder.readUInt32("NodeClassMask");
            UInteger resultMask = decoder.readUInt32("ResultMask");
            return new BrowseDescription(nodeId, browseDirection, referenceTypeId, includeSubtypes, nodeClassMask, resultMask);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseDescription value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("BrowseDirection", value.getBrowseDirection());
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IncludeSubtypes", value.getIncludeSubtypes());
            encoder.writeUInt32("NodeClassMask", value.getNodeClassMask());
            encoder.writeUInt32("ResultMask", value.getResultMask());
        }
    }
}

