/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TopKNode
extends MultiChildProcessNode {
    private final OrderingScheme orderingScheme;
    private final long count;
    private final List<Symbol> outputSymbols;
    private final boolean childrenDataInOrder;

    public TopKNode(PlanNodeId id, OrderingScheme scheme, long count, List<Symbol> outputSymbols, boolean childrenDataInOrder) {
        super(id);
        this.orderingScheme = scheme;
        this.count = count;
        this.outputSymbols = outputSymbols;
        this.childrenDataInOrder = childrenDataInOrder;
    }

    public TopKNode(PlanNodeId id, List<PlanNode> children, OrderingScheme scheme, long count, List<Symbol> outputSymbols, boolean childrenDataInOrder) {
        super(id, children);
        this.orderingScheme = scheme;
        this.count = count;
        this.outputSymbols = outputSymbols;
        this.childrenDataInOrder = childrenDataInOrder;
    }

    @Override
    public PlanNode clone() {
        return new TopKNode(this.getPlanNodeId(), this.orderingScheme, this.count, this.outputSymbols, this.childrenDataInOrder);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopK(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_TOPK_NODE.serialize(byteBuffer);
        this.orderingScheme.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.count, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.childrenDataInOrder, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_TOPK_NODE.serialize(stream);
        this.orderingScheme.serialize(stream);
        ReadWriteIOUtils.write((long)this.count, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.outputSymbols.size(), (OutputStream)stream);
        for (Symbol symbol : this.outputSymbols) {
            Symbol.serialize(symbol, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.childrenDataInOrder, (OutputStream)stream);
    }

    public static TopKNode deserialize(ByteBuffer byteBuffer) {
        OrderingScheme orderingScheme = OrderingScheme.deserialize(byteBuffer);
        long count = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> outputSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            outputSymbols.add(Symbol.deserialize(byteBuffer));
        }
        boolean childrenDataInOrder = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TopKNode(planNodeId, orderingScheme, count, outputSymbols, childrenDataInOrder);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((this.children.size() == newChildren.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new TopKNode(this.id, newChildren, this.orderingScheme, this.count, this.outputSymbols, this.childrenDataInOrder);
    }

    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    public long getCount() {
        return this.count;
    }

    public boolean isChildrenDataInOrder() {
        return this.childrenDataInOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopKNode sortNode = (TopKNode)o;
        return Objects.equal((Object)this.orderingScheme, (Object)sortNode.orderingScheme) && Objects.equal(this.outputSymbols, sortNode.outputSymbols) && Objects.equal((Object)this.count, (Object)sortNode.count);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.orderingScheme, this.outputSymbols, this.count});
    }

    public String toString() {
        return "TopKNode-" + this.getPlanNodeId();
    }
}

