/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeOperateSchemaQueueNode
extends PlanNode {
    private final boolean isOpen;

    public PipeOperateSchemaQueueNode(PlanNodeId id, boolean isOpen) {
        super(id);
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new PipeOperateSchemaQueueNode(this.id, this.isOpen);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPipeOperateSchemaQueueNode(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.PIPE_OPERATE_SCHEMA_QUEUE_REFERENCE.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isOpen, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.PIPE_OPERATE_SCHEMA_QUEUE_REFERENCE.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isOpen, (OutputStream)stream);
    }

    public static PipeOperateSchemaQueueNode deserialize(ByteBuffer byteBuffer) {
        boolean isOpen = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new PipeOperateSchemaQueueNode(planNodeId, isOpen);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeOperateSchemaQueueNode that = (PipeOperateSchemaQueueNode)o;
        return Objects.equals(this.getPlanNodeId(), that.getPlanNodeId()) && Objects.equals(this.isOpen, that.isOpen);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.isOpen);
    }
}

