/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemoryStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.MemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;

public class PBTreeFactory {
    public static PBTreeFactory getInstance() {
        return PBTreeFactoryHolder.INSTANCE;
    }

    private PBTreeFactory() {
    }

    public CachedMTreeStore createNewCachedMTreeStore(PartialPath storageGroup, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric, Runnable flushCallback) throws MetadataException, IOException {
        SchemaFile schemaFile = SchemaFile.initSchemaFile(storageGroup.getFullPath(), schemaRegionId);
        schemaFile.setMetric(metric);
        return this.createCachedMTreeStore(schemaRegionId, regionStatistics, metric, flushCallback, schemaFile);
    }

    public CachedMTreeStore createCachedMTreeStoreFromSnapshot(File snapshotDir, String storageGroup, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric, Runnable flushCallback) throws MetadataException, IOException {
        SchemaFile schemaFile = SchemaFile.loadSnapshot(snapshotDir, storageGroup, schemaRegionId);
        schemaFile.setMetric(metric);
        return this.createCachedMTreeStore(schemaRegionId, regionStatistics, metric, flushCallback, schemaFile);
    }

    private CachedMTreeStore createCachedMTreeStore(int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric, Runnable flushCallback, ISchemaFile schemaFile) throws MetadataException {
        MemoryStatistics memoryStatistics = new MemoryStatistics(regionStatistics);
        LockManager lockManager = new LockManager();
        MemoryManager memoryManager = new MemoryManager(memoryStatistics, lockManager);
        regionStatistics.setMemoryManager(memoryManager);
        ReleaseFlushMonitor releaseFlushMonitor = ReleaseFlushMonitor.getInstance();
        CachedMTreeStore cachedMTreeStore = new CachedMTreeStore(schemaRegionId, regionStatistics, metric, flushCallback, schemaFile, memoryManager, memoryStatistics, lockManager);
        releaseFlushMonitor.registerCachedMTreeStore(cachedMTreeStore);
        return cachedMTreeStore;
    }

    private static class PBTreeFactoryHolder {
        private static PBTreeFactory INSTANCE = new PBTreeFactory();

        private PBTreeFactoryHolder() {
        }
    }
}

