/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Platform;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length2) {
        return (Object[])Array.newInstance(type, length2);
    }

    public static <T> T[] newArray(T[] reference, int length2) {
        return Platform.newArray(reference, length2);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first2, T[] second2, Class<T> type) {
        T[] result2 = ObjectArrays.newArray(type, first2.length + second2.length);
        System.arraycopy(first2, 0, result2, 0, first2.length);
        System.arraycopy(second2, 0, result2, first2.length, second2.length);
        return result2;
    }

    public static <T> T[] concat(@Nullable T element2, T[] array) {
        T[] result2 = ObjectArrays.newArray(array, array.length + 1);
        result2[0] = element2;
        System.arraycopy(array, 0, result2, 1, array.length);
        return result2;
    }

    public static <T> T[] concat(T[] array, @Nullable T element2) {
        T[] result2 = ObjectArrays.arraysCopyOf(array, array.length + 1);
        result2[array.length] = element2;
        return result2;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        T[] copy2 = ObjectArrays.newArray(original, newLength);
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, newLength));
        return copy2;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size2 = c.size();
        if (array.length < size2) {
            array = ObjectArrays.newArray(array, size2);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size2) {
            array[size2] = null;
        }
        return array;
    }

    static <T> T[] toArrayImpl(Object[] src, int offset, int len2, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len2, src.length);
        if (dst.length < len2) {
            dst = ObjectArrays.newArray(dst, len2);
        } else if (dst.length > len2) {
            dst[len2] = null;
        }
        System.arraycopy(src, offset, dst, 0, len2);
        return dst;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    static Object[] copyAsObjectArray(Object[] elements, int offset, int length2) {
        Preconditions.checkPositionIndexes(offset, offset + length2, elements.length);
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result2 = new Object[length2];
        System.arraycopy(elements, offset, result2, 0, length2);
        return result2;
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i = 0;
        for (Object element2 : elements) {
            array[i++] = element2;
        }
        return array;
    }

    static void swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    static Object[] checkElementsNotNull(Object[] array, int length2) {
        for (int i = 0; i < length2; ++i) {
            ObjectArrays.checkElementNotNull(array[i], i);
        }
        return array;
    }

    static Object checkElementNotNull(Object element2, int index2) {
        if (element2 == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element2;
    }
}

