/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string2) {
        return string2 == null ? "" : string2;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string2) {
        return Strings.isNullOrEmpty(string2) ? null : string2;
    }

    public static boolean isNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String padStart(String string2, int minLength2, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength2) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength2);
        for (int i = string2.length(); i < minLength2; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength2, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength2) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength2);
        sb.append(string2);
        for (int i = string2.length(); i < minLength2; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len2 = string2.length();
        long longSize = (long)len2 * (long)count2;
        int size2 = (int)longSize;
        if ((long)size2 != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(longSize));
        }
        char[] array = new char[size2];
        string2.getChars(0, len2, array, 0);
        for (n = len2; n < size2 - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size2 - n);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a2, CharSequence b2) {
        int p;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxPrefixLength = Math.min(a2.length(), b2.length());
        for (p = 0; p < maxPrefixLength && a2.charAt(p) == b2.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a2, p - 1) || Strings.validSurrogatePairAt(b2, p - 1)) {
            --p;
        }
        return a2.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a2, CharSequence b2) {
        int s;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxSuffixLength = Math.min(a2.length(), b2.length());
        for (s = 0; s < maxSuffixLength && a2.charAt(a2.length() - s - 1) == b2.charAt(b2.length() - s - 1); ++s) {
        }
        if (Strings.validSurrogatePairAt(a2, a2.length() - s - 1) || Strings.validSurrogatePairAt(b2, b2.length() - s - 1)) {
            --s;
        }
        return a2.subSequence(a2.length() - s, a2.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string2, int index2) {
        return index2 >= 0 && index2 <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index2)) && Character.isLowSurrogate(string2.charAt(index2 + 1));
    }
}

