/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.model.consequences;

import org.drools.model.Consequence;
import org.drools.model.Drools;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block0;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Block10;
import org.drools.model.functions.Block11;
import org.drools.model.functions.Block12;
import org.drools.model.functions.Block13;
import org.drools.model.functions.Block14;
import org.drools.model.functions.Block15;
import org.drools.model.functions.Block16;
import org.drools.model.functions.Block17;
import org.drools.model.functions.Block18;
import org.drools.model.functions.Block19;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block20;
import org.drools.model.functions.Block21;
import org.drools.model.functions.Block22;
import org.drools.model.functions.Block23;
import org.drools.model.functions.Block24;
import org.drools.model.functions.Block25;
import org.drools.model.functions.Block26;
import org.drools.model.functions.Block27;
import org.drools.model.functions.Block28;
import org.drools.model.functions.Block29;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Block30;
import org.drools.model.functions.Block31;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Block5;
import org.drools.model.functions.Block6;
import org.drools.model.functions.Block7;
import org.drools.model.functions.Block8;
import org.drools.model.functions.Block9;
import org.drools.model.functions.BlockN;
import org.drools.model.functions.ScriptBlock;

// Generated by ConsequenceGenerator, please do not change this file manually
public class ConsequenceBuilder {

    public _0 execute(Block0 block) {
        return new _0(block);
    }

    public _0 execute(Block1<Drools> block) {
        return new _0(block);
    }

    public <A> _1<A> on(Variable<A> dec1) {
        return new _1(dec1);
    }

    public <A, B> _2<A, B> on(Variable<A> decl1, Variable<B> decl2) {
        return new _2(decl1, decl2);
    }

    public interface ValidBuilder extends RuleItemBuilder<Consequence> {
    }

    public static abstract class AbstractValidBuilder<T extends AbstractValidBuilder> implements ValidBuilder {

        private final Variable[] declarations;

        protected BlockN block;

        protected boolean usingDrools = false;

        protected boolean breaking = false;

        protected String language = "java";

        protected AbstractValidBuilder(Variable... declarations) {
            this.declarations = declarations;
        }

        @Override
        public Consequence get() {
            return new ConsequenceImpl(block, declarations, usingDrools, breaking, language);
        }

        public T breaking() {
            breaking = true;
            return (T) this;
        }
    }

    public static class _0 extends AbstractValidBuilder<_0> {

        public _0(final Block0 block) {
            super();
            this.block = block.asBlockN();
        }

        public _0(final Block1<Drools> block) {
            super();
            this.usingDrools = true;
            this.block = block.asBlockN();
        }

        public _0(String language, Class<?> ruleClass, String script) {
            super();
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
        }
    }

    public static class _N extends AbstractValidBuilder<_N> {

        public _N(Variable... declarations) {
            super(declarations);
        }

        public _N executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _1<T1> extends AbstractValidBuilder<_1<T1>> {

        public _1(Variable<T1> arg1) {
            super(arg1);
        }

        public _1<T1> execute(final Block1<T1> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _1<T1> execute(final Block2<Drools, T1> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _1<T1> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _2<T1, T2> extends AbstractValidBuilder<_2<T1, T2>> {

        public _2(Variable<T1> arg1, Variable<T2> arg2) {
            super(arg1, arg2);
        }

        public _2<T1, T2> execute(final Block2<T1, T2> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _2<T1, T2> execute(final Block3<Drools, T1, T2> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _2<T1, T2> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _3<T1, T2, T3> extends AbstractValidBuilder<_3<T1, T2, T3>> {

        public _3(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3) {
            super(arg1, arg2, arg3);
        }

        public _3<T1, T2, T3> execute(final Block3<T1, T2, T3> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _3<T1, T2, T3> execute(final Block4<Drools, T1, T2, T3> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _3<T1, T2, T3> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _4<T1, T2, T3, T4> extends AbstractValidBuilder<_4<T1, T2, T3, T4>> {

        public _4(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4) {
            super(arg1, arg2, arg3, arg4);
        }

        public _4<T1, T2, T3, T4> execute(final Block4<T1, T2, T3, T4> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _4<T1, T2, T3, T4> execute(final Block5<Drools, T1, T2, T3, T4> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _4<T1, T2, T3, T4> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _5<T1, T2, T3, T4, T5> extends AbstractValidBuilder<_5<T1, T2, T3, T4, T5>> {

        public _5(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5) {
            super(arg1, arg2, arg3, arg4, arg5);
        }

        public _5<T1, T2, T3, T4, T5> execute(final Block5<T1, T2, T3, T4, T5> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _5<T1, T2, T3, T4, T5> execute(final Block6<Drools, T1, T2, T3, T4, T5> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _5<T1, T2, T3, T4, T5> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _6<T1, T2, T3, T4, T5, T6> extends AbstractValidBuilder<_6<T1, T2, T3, T4, T5, T6>> {

        public _6(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6) {
            super(arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public _6<T1, T2, T3, T4, T5, T6> execute(final Block6<T1, T2, T3, T4, T5, T6> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _6<T1, T2, T3, T4, T5, T6> execute(final Block7<Drools, T1, T2, T3, T4, T5, T6> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _6<T1, T2, T3, T4, T5, T6> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _7<T1, T2, T3, T4, T5, T6, T7> extends AbstractValidBuilder<_7<T1, T2, T3, T4, T5, T6, T7>> {

        public _7(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }

        public _7<T1, T2, T3, T4, T5, T6, T7> execute(final Block7<T1, T2, T3, T4, T5, T6, T7> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _7<T1, T2, T3, T4, T5, T6, T7> execute(final Block8<Drools, T1, T2, T3, T4, T5, T6, T7> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _7<T1, T2, T3, T4, T5, T6, T7> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _8<T1, T2, T3, T4, T5, T6, T7, T8> extends AbstractValidBuilder<_8<T1, T2, T3, T4, T5, T6, T7, T8>> {

        public _8(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }

        public _8<T1, T2, T3, T4, T5, T6, T7, T8> execute(final Block8<T1, T2, T3, T4, T5, T6, T7, T8> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _8<T1, T2, T3, T4, T5, T6, T7, T8> execute(final Block9<Drools, T1, T2, T3, T4, T5, T6, T7, T8> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _8<T1, T2, T3, T4, T5, T6, T7, T8> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _9<T1, T2, T3, T4, T5, T6, T7, T8, T9> extends AbstractValidBuilder<_9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> {

        public _9(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        }

        public _9<T1, T2, T3, T4, T5, T6, T7, T8, T9> execute(final Block9<T1, T2, T3, T4, T5, T6, T7, T8, T9> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _9<T1, T2, T3, T4, T5, T6, T7, T8, T9> execute(final Block10<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _9<T1, T2, T3, T4, T5, T6, T7, T8, T9> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> extends AbstractValidBuilder<_10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> {

        public _10(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }

        public _10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> execute(final Block10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> execute(final Block11<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> extends AbstractValidBuilder<_11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> {

        public _11(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
        }

        public _11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> execute(final Block11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> execute(final Block12<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> extends AbstractValidBuilder<_12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> {

        public _12(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
        }

        public _12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> execute(final Block12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> execute(final Block13<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> extends AbstractValidBuilder<_13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> {

        public _13(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
        }

        public _13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> execute(final Block13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> execute(final Block14<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> extends AbstractValidBuilder<_14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> {

        public _14(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
        }

        public _14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> execute(final Block14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> execute(final Block15<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> extends AbstractValidBuilder<_15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> {

        public _15(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
        }

        public _15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> execute(final Block15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> execute(final Block16<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> extends AbstractValidBuilder<_16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> {

        public _16(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
        }

        public _16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> execute(final Block16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> execute(final Block17<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> extends AbstractValidBuilder<_17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> {

        public _17(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
        }

        public _17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> execute(final Block17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> execute(final Block18<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> extends AbstractValidBuilder<_18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> {

        public _18(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
        }

        public _18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> execute(final Block18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> execute(final Block19<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> extends AbstractValidBuilder<_19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> {

        public _19(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
        }

        public _19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> execute(final Block19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> execute(final Block20<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> extends AbstractValidBuilder<_20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> {

        public _20(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
        }

        public _20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> execute(final Block20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> execute(final Block21<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> extends AbstractValidBuilder<_21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> {

        public _21(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21);
        }

        public _21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> execute(final Block21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> execute(final Block22<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> extends AbstractValidBuilder<_22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> {

        public _22(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22);
        }

        public _22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> execute(final Block22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> execute(final Block23<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> extends AbstractValidBuilder<_23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> {

        public _23(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23);
        }

        public _23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> execute(final Block23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> execute(final Block24<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> extends AbstractValidBuilder<_24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> {

        public _24(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24);
        }

        public _24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> execute(final Block24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> execute(final Block25<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }


    public static class _25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> extends AbstractValidBuilder<_25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25>> {

        public _25(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25);
        }

        public _25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> execute(final Block25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> execute(final Block26<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> extends AbstractValidBuilder<_26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26>> {

        public _26(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25, Variable<T26> arg26) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26);
        }

        public _26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> execute(final Block26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> execute(final Block27<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> extends AbstractValidBuilder<_27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27>> {

        public _27(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25, Variable<T26> arg26, Variable<T27> arg27) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27);
        }

        public _27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> execute(final Block27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> execute(final Block28<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> extends AbstractValidBuilder<_28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28>> {

        public _28(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25, Variable<T26> arg26, Variable<T27> arg27, Variable<T28> arg28) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28);
        }

        public _28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> execute(final Block28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> execute(final Block29<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> extends AbstractValidBuilder<_29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29>> {

        public _29(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25, Variable<T26> arg26, Variable<T27> arg27, Variable<T28> arg28, Variable<T29> arg29) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29);
        }

        public _29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> execute(final Block29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> execute(final Block30<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

    public static class _30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> extends AbstractValidBuilder<_30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30>> {

        public _30(Variable<T1> arg1, Variable<T2> arg2, Variable<T3> arg3, Variable<T4> arg4, Variable<T5> arg5, Variable<T6> arg6, Variable<T7> arg7, Variable<T8> arg8, Variable<T9> arg9, Variable<T10> arg10, Variable<T11> arg11, Variable<T12> arg12, Variable<T13> arg13, Variable<T14> arg14, Variable<T15> arg15, Variable<T16> arg16, Variable<T17> arg17, Variable<T18> arg18, Variable<T19> arg19, Variable<T20> arg20, Variable<T21> arg21, Variable<T22> arg22, Variable<T23> arg23, Variable<T24> arg24, Variable<T25> arg25, Variable<T26> arg26, Variable<T27> arg27, Variable<T28> arg28, Variable<T29> arg29, Variable<T30> arg30) {
            super(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29, arg30);
        }

        public _30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> execute(final Block30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> block) {
            this.block = block.asBlockN();
            return this;
        }

        public _30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> execute(final Block31<Drools, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> block) {
            this.usingDrools = true;
            this.block = block.asBlockN();
            return this;
        }

        public _30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30> executeScript(String language, Class<?> ruleClass, String script) {
            this.usingDrools = true;
            this.language = language;
            this.block = new ScriptBlock(ruleClass, script);
            return this;
        }
    }

}
