<!--
   Licensed to the Apache Software Foundation (ASF) under one
   or more contributor license agreements.  See the NOTICE file
   distributed with this work for additional information
   regarding copyright ownership.  The ASF licenses this file
   to you under the Apache License, Version 2.0 (the
   "License"); you may not use this file except in compliance
   with the License.  You may obtain a copy of the License at
     http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing,
   software distributed under the License is distributed on an
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   KIND, either express or implied.  See the License for the
   specific language governing permissions and limitations
   under the License.
-->

# incubator-kie-sandbox-helm-chart

![Version: 10.1.0](https://img.shields.io/badge/Version-10.1.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 10.1.0](https://img.shields.io/badge/AppVersion-10.1.0-informational?style=flat-square)

A Helm chart to deploy KIE Sandbox and related services on Kubernetes

## Requirements

| Repository | Name              | Version |
| ---------- | ----------------- | ------- |
|            | cors_proxy        | 10.1.0  |
|            | extended_services | 10.1.0  |
|            | kie_sandbox       | 10.1.0  |

## Values

| Key                                | Type   | Default                                                                                                                                                                                                                                                | Description                                                                                                                                     |
| ---------------------------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------- |
| global.ingressSource               | string | `""`                                                                                                                                                                                                                                                   | Which ingress source is being used (none/"minikube"/"kubernetes"/"openshift") Obs.: For NOTES generation only                                   |
| global.kubernetesClusterDomain     | string | `""`                                                                                                                                                                                                                                                   | If using Minikube or Kubernetes, set the cluster domain                                                                                         |
| global.kubernetesIngressClass      | string | `""`                                                                                                                                                                                                                                                   | If using Minikube or Kubernetes, set the Ingress class (i.e: nginx)                                                                             |
| global.openshiftRouteDomain        | string | `""`                                                                                                                                                                                                                                                   | If using OpenShift Routes, set the Route domain                                                                                                 |
| fullnameOverride                   | string | `""`                                                                                                                                                                                                                                                   | Overrides charts full name                                                                                                                      |
| nameOverride                       | string | `""`                                                                                                                                                                                                                                                   | Overrides charts name                                                                                                                           |
| cors_proxy.autoscaling             | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                              | CORS Proxy HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)                   |
| cors_proxy.fullnameOverride        | string | `""`                                                                                                                                                                                                                                                   | Overrides charts full name                                                                                                                      |
| cors_proxy.image                   | object | `{"account":"apache","name":"incubator-kie-cors-proxy","pullPolicy":"IfNotPresent","registry":"docker.io","tag":"10.1.0"}`                                                                                                                             | Image source configuration for the CORS Proxy image                                                                                             |
| cors_proxy.imagePullSecrets        | list   | `[]`                                                                                                                                                                                                                                                   | Pull secrets used when pulling CORS Proxy image                                                                                                 |
| cors_proxy.ingress                 | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"cors-proxy.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}`        | CORS Proxy Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                             |
| cors_proxy.name                    | string | `"cors-proxy"`                                                                                                                                                                                                                                         | The CORS Proxy application name                                                                                                                 |
| cors_proxy.nameOverride            | string | `""`                                                                                                                                                                                                                                                   | Overrides charts name                                                                                                                           |
| cors_proxy.nodeSelector            | object | `{}`                                                                                                                                                                                                                                                   |                                                                                                                                                 |
| cors_proxy.openshiftRoute          | object | `{"annotations":{},"enabled":false,"host":"cors-proxy.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                                 | CORS Proxy OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html)        |
| cors_proxy.service                 | object | `{"nodePort":"","port":8080,"type":"ClusterIP"}`                                                                                                                                                                                                       | CORS Proxy Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                             |
| cors_proxy.serviceAccount          | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                           | CORS Proxy ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                        |
| extended_services.autoscaling      | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                              | Extended Services HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)            |
| extended_services.fullnameOverride | string | `""`                                                                                                                                                                                                                                                   | Overrides charts full name                                                                                                                      |
| extended_services.image            | object | `{"account":"apache","name":"incubator-kie-sandbox-extended-services","pullPolicy":"IfNotPresent","registry":"docker.io","tag":"10.1.0"}`                                                                                                              | Image source configuration for the Extended Services image                                                                                      |
| extended_services.imagePullSecrets | list   | `[]`                                                                                                                                                                                                                                                   | Pull secrets used when pulling Extended Services image                                                                                          |
| extended_services.ingress          | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"extended-services.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}` | Extended Services Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                      |
| extended_services.name             | string | `"extended-services"`                                                                                                                                                                                                                                  | The Extended Services application name                                                                                                          |
| extended_services.nameOverride     | string | `""`                                                                                                                                                                                                                                                   | Overrides charts name                                                                                                                           |
| extended_services.nodeSelector     | object | `{}`                                                                                                                                                                                                                                                   |                                                                                                                                                 |
| extended_services.openshiftRoute   | object | `{"annotations":{},"enabled":false,"host":"extended-services.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                          | Extended Services OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html) |
| extended_services.service          | object | `{"nodePort":"","port":21345,"type":"ClusterIP"}`                                                                                                                                                                                                      | Extended Services Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                      |
| extended_services.serviceAccount   | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                           | Extended Services ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                 |
| kie_sandbox.autoscaling            | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                              | KIE Sandbox HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)                  |
| kie_sandbox.env                    | list   | `[{"name":"KIE_SANDBOX_EXTENDED_SERVICES_URL","value":"http://127.0.0.1:21345"},{"name":"KIE_SANDBOX_CORS_PROXY_URL","value":"http://127.0.0.1:8081"}]`                                                                                                | Env variables for KIE Sandbox deployment                                                                                                        |
| kie_sandbox.fullnameOverride       | string | `""`                                                                                                                                                                                                                                                   | Overrides charts full name                                                                                                                      |
| kie_sandbox.image                  | object | `{"account":"apache","name":"incubator-kie-sandbox-webapp","pullPolicy":"IfNotPresent","registry":"docker.io","tag":"10.1.0"}`                                                                                                                         | Image source configuration for the KIE Sandbox image                                                                                            |
| kie_sandbox.imagePullSecrets       | list   | `[]`                                                                                                                                                                                                                                                   | Pull secrets used when pulling KIE Sandbox image                                                                                                |
| kie_sandbox.ingress                | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"kie-sandbox.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}`       | KIE Sandbox Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                            |
| kie_sandbox.name                   | string | `"kie-sandbox"`                                                                                                                                                                                                                                        | The KIE Sandbox application name                                                                                                                |
| kie_sandbox.nameOverride           | string | `""`                                                                                                                                                                                                                                                   | Overrides charts name                                                                                                                           |
| kie_sandbox.openshiftRoute         | object | `{"annotations":{},"enabled":false,"host":"kie-sandbox.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                                | KIE Sandbox OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html)       |
| kie_sandbox.service                | object | `{"nodePort":"","port":8080,"type":"ClusterIP"}`                                                                                                                                                                                                       | KIE Sandbox Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                            |
| kie_sandbox.serviceAccount         | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                           | KIE Sandbox ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                       |

---

Autogenerated from chart metadata using [helm-docs v1.13.1](https://github.com/norwoodj/helm-docs/releases/v1.13.1)
