/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hugegraph.rest.SerializeException;

public final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void registerModule(Module module) {
        MAPPER.registerModule(module);
    }

    public static String toJson(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SerializeException("Failed to serialize object '%s'", (Throwable)e, new Object[]{object});
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize json '%s'", (Throwable)e, new Object[]{json});
        }
    }

    public static <T> T convertValue(JsonNode node, Class<T> clazz) {
        try {
            return (T)MAPPER.convertValue((Object)node, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new SerializeException("Failed to deserialize json node '%s'", (Throwable)e, new Object[]{node});
        }
    }
}

