/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.perf;

import java.util.List;

public interface Stopwatch
extends Cloneable {
    public Path id();

    public String name();

    public Path parent();

    public void startTime(long var1);

    public void endTime(long var1);

    public void lastStartTime(long var1);

    public long times();

    public long totalTimes();

    public long totalChildrenTimes();

    public long totalCost();

    public void totalCost(long var1);

    public long minCost();

    public long maxCost();

    public long totalWasted();

    public long totalSelfWasted();

    public long totalChildrenWasted();

    public void fillChildrenTotal(List<Stopwatch> var1);

    public Stopwatch copy();

    public Stopwatch child(String var1);

    public Stopwatch child(String var1, Stopwatch var2);

    public boolean empty();

    public void clear();

    default public String toJson() {
        int len = 200 + this.name().length() + this.parent().length();
        StringBuilder sb = new StringBuilder(len);
        sb.append("{");
        sb.append("\"parent\":\"").append(this.parent()).append("\"");
        sb.append(",\"name\":\"").append(this.name()).append("\"");
        sb.append(",\"times\":").append(this.times());
        sb.append(",\"total_cost\":").append(this.totalCost());
        sb.append(",\"min_cost\":").append(this.minCost());
        sb.append(",\"max_cost\":").append(this.maxCost());
        sb.append(",\"total_self_wasted\":").append(this.totalSelfWasted());
        sb.append(",\"total_children_wasted\":").append(this.totalChildrenWasted());
        sb.append(",\"total_children_times\":").append(this.totalChildrenTimes());
        sb.append("}");
        return sb.toString();
    }

    public static Path id(Path parent, String name) {
        if (parent == Path.EMPTY && name == "root") {
            return Path.EMPTY;
        }
        return new Path(parent, name);
    }

    public static final class Path
    implements Comparable<Path> {
        public static final String ROOT_NAME = "root";
        public static final Path EMPTY = new Path("");
        private final String path;

        public Path(String self) {
            this.path = self;
        }

        public Path(Path parent, String name) {
            this.path = parent == EMPTY ? name : parent.path + '/' + name;
        }

        public int length() {
            return this.path.length();
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (!(obj instanceof Path)) {
                return false;
            }
            Path other = (Path)obj;
            return this.path.equals(other.path);
        }

        @Override
        public int compareTo(Path other) {
            return this.path.compareTo(other.path);
        }

        public String toString() {
            return this.path;
        }

        public boolean endsWith(String name) {
            return this.path.endsWith(name);
        }
    }
}

