/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.ContextualSourceFieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.util.Asserts;

public class ContextualSourceFieldMapperImpl<S, T>
implements ContextualSourceFieldMapper<S, T> {
    private final MappingContextFactory<? super S> mappingContextFactory;
    private final SourceFieldMapper<S, T> delegate;

    public ContextualSourceFieldMapperImpl(MappingContextFactory<? super S> mappingContextFactory, SourceFieldMapper<S, T> delegate) {
        this.mappingContextFactory = (MappingContextFactory)Asserts.requireNonNull((String)"mappingContextFactory", mappingContextFactory);
        this.delegate = (SourceFieldMapper)Asserts.requireNonNull((String)"delegate", delegate);
    }

    public SourceFieldMapper<S, T> getDelegate() {
        return this.delegate;
    }

    public MappingContext<? super S> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }

    @Override
    public T map(S source) throws MappingException {
        Context context = this.mappingContextFactory.newContext();
        context.handleSource(source);
        return this.delegate.map(source, (MappingContext<S>)context);
    }

    @Override
    public T map(S source, MappingContext<? super S> context) throws MappingException {
        return this.delegate.map((S)source, context);
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        this.delegate.mapTo((S)source, target, context);
    }

    public String toString() {
        return "ContextualSourceMapperImpl{mappingContextFactory=" + this.mappingContextFactory + ", delegate=" + this.delegate + '}';
    }

    public MappingContextFactory<? super S> getMappingContextFactory() {
        return this.mappingContextFactory;
    }
}

