/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.BaseRemoting;
import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.Url;
import com.alipay.remoting.config.switches.ProtocolSwitch;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.DefaultInvokeFuture;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.RpcInvokeCallbackListener;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.rpc.RpcResponseResolver;
import com.alipay.remoting.rpc.protocol.RpcProtocolManager;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.util.RemotingUtil;
import org.slf4j.Logger;

public abstract class RpcRemoting
extends BaseRemoting {
    private static final Logger logger;
    protected RemotingAddressParser addressParser;
    protected DefaultConnectionManager connectionManager;

    public RpcRemoting(CommandFactory commandFactory) {
        super(commandFactory);
    }

    public RpcRemoting(CommandFactory commandFactory, RemotingAddressParser addressParser, DefaultConnectionManager connectionManager) {
        this(commandFactory);
        this.addressParser = addressParser;
        this.connectionManager = connectionManager;
    }

    public void oneway(String addr, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        Url url = this.addressParser.parse(addr);
        this.oneway(url, request, invokeContext);
    }

    public abstract void oneway(Url var1, Object var2, InvokeContext var3) throws RemotingException, InterruptedException;

    public void oneway(Connection conn, Object request, InvokeContext invokeContext) throws RemotingException {
        RequestCommand requestCommand = (RequestCommand)this.toRemotingCommand(request, conn, invokeContext, -1);
        requestCommand.setType((byte)2);
        this.preProcessInvokeContext(invokeContext, requestCommand, conn);
        super.oneway(conn, requestCommand);
    }

    public Object invokeSync(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        Url url = this.addressParser.parse(addr);
        return this.invokeSync(url, request, invokeContext, timeoutMillis);
    }

    public abstract Object invokeSync(Url var1, Object var2, InvokeContext var3, int var4) throws RemotingException, InterruptedException;

    public Object invokeSync(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        RemotingCommand requestCommand = this.toRemotingCommand(request, conn, invokeContext, timeoutMillis);
        this.preProcessInvokeContext(invokeContext, requestCommand, conn);
        ResponseCommand responseCommand = (ResponseCommand)super.invokeSync(conn, requestCommand, timeoutMillis);
        responseCommand.setInvokeContext(invokeContext);
        Object responseObject = RpcResponseResolver.resolveResponseObject(responseCommand, RemotingUtil.parseRemoteAddress(conn.getChannel()));
        return responseObject;
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        Url url = this.addressParser.parse(addr);
        return this.invokeWithFuture(url, request, invokeContext, timeoutMillis);
    }

    public abstract RpcResponseFuture invokeWithFuture(Url var1, Object var2, InvokeContext var3, int var4) throws RemotingException, InterruptedException;

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException {
        RemotingCommand requestCommand = this.toRemotingCommand(request, conn, invokeContext, timeoutMillis);
        this.preProcessInvokeContext(invokeContext, requestCommand, conn);
        InvokeFuture future = super.invokeWithFuture(conn, requestCommand, timeoutMillis);
        return new RpcResponseFuture(RemotingUtil.parseRemoteAddress(conn.getChannel()), future);
    }

    public void invokeWithCallback(String addr, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        Url url = this.addressParser.parse(addr);
        this.invokeWithCallback(url, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public abstract void invokeWithCallback(Url var1, Object var2, InvokeContext var3, InvokeCallback var4, int var5) throws RemotingException, InterruptedException;

    public void invokeWithCallback(Connection conn, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        RemotingCommand requestCommand = this.toRemotingCommand(request, conn, invokeContext, timeoutMillis);
        this.preProcessInvokeContext(invokeContext, requestCommand, conn);
        super.invokeWithCallback(conn, requestCommand, invokeCallback, timeoutMillis);
    }

    protected RemotingCommand toRemotingCommand(Object request, Connection conn, InvokeContext invokeContext, int timeoutMillis) throws SerializationException {
        RpcRequestCommand command = (RpcRequestCommand)this.getCommandFactory().createRequestCommand(request);
        if (null != invokeContext) {
            Boolean crcSwitch;
            Object clientCustomSerializer = invokeContext.get("bolt.invoke.custom.serializer");
            if (null != clientCustomSerializer) {
                try {
                    command.setSerializer((Byte)clientCustomSerializer);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Illegal custom serializer [" + clientCustomSerializer + "], the type of value should be [byte], but now is [" + clientCustomSerializer.getClass().getName() + "].");
                }
            }
            if (null != (crcSwitch = invokeContext.get("bolt.invoke.crc.switch", true)) && crcSwitch.booleanValue()) {
                command.setProtocolSwitch(ProtocolSwitch.create(new int[]{0}));
            }
        } else {
            command.setProtocolSwitch(ProtocolSwitch.create(new int[]{0}));
        }
        command.setTimeout(timeoutMillis);
        command.setRequestClass(request.getClass().getName());
        command.setInvokeContext(invokeContext);
        command.serialize();
        this.logDebugInfo(command);
        return command;
    }

    protected abstract void preProcessInvokeContext(InvokeContext var1, RemotingCommand var2, Connection var3);

    private void logDebugInfo(RemotingCommand requestCommand) {
        if (logger.isDebugEnabled()) {
            logger.debug("Send request, requestId=" + requestCommand.getId());
        }
    }

    @Override
    protected InvokeFuture createInvokeFuture(RemotingCommand request, InvokeContext invokeContext) {
        return new DefaultInvokeFuture(request.getId(), null, null, request.getProtocolCode().getFirstByte(), this.getCommandFactory(), invokeContext);
    }

    @Override
    protected InvokeFuture createInvokeFuture(Connection conn, RemotingCommand request, InvokeContext invokeContext, InvokeCallback invokeCallback) {
        return new DefaultInvokeFuture(request.getId(), new RpcInvokeCallbackListener(RemotingUtil.parseRemoteAddress(conn.getChannel())), invokeCallback, request.getProtocolCode().getFirstByte(), this.getCommandFactory(), invokeContext);
    }

    static {
        RpcProtocolManager.initProtocols();
        logger = BoltLoggerFactory.getLogger("RpcRemoting");
    }
}

