/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class OptionSpace {
    private static final Logger LOG = Log.logger(OptionSpace.class);
    private static final Map<String, Class<? extends OptionHolder>> HOLDERS = new ConcurrentHashMap<String, Class<? extends OptionHolder>>();
    private static final Map<String, TypedOption<?, ?>> OPTIONS = new ConcurrentHashMap();
    private static final String INSTANCE_METHOD = "instance";

    public static void register(String module, String holder) {
        Class<?> clazz;
        ClassLoader classLoader = OptionSpace.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(holder);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Failed to load class of option holder '%s'", (Throwable)e, holder);
        }
        if (!OptionHolder.class.isAssignableFrom(clazz)) {
            throw new ConfigException("Class '%s' is not a subclass of OptionHolder", holder);
        }
        OptionHolder instance = null;
        Exception exception = null;
        try {
            Method method = clazz.getMethod(INSTANCE_METHOD, new Class[0]);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchMethodException(INSTANCE_METHOD);
            }
            instance = (OptionHolder)method.invoke(null, new Object[0]);
            if (instance == null) {
                exception = new ConfigException("Returned null from %s() method", INSTANCE_METHOD);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Class {} does not has static method {}.", (Object)holder, (Object)INSTANCE_METHOD);
            exception = e;
        }
        catch (InvocationTargetException e) {
            LOG.warn("Can't call static method {} from class {}.", (Object)INSTANCE_METHOD, (Object)holder);
            exception = e;
        }
        catch (IllegalAccessException e) {
            LOG.warn("Illegal access while calling method {} from class {}.", (Object)INSTANCE_METHOD, (Object)holder);
            exception = e;
        }
        if (exception != null) {
            throw new ConfigException("Failed to instantiate option holder: %s", (Throwable)exception, holder);
        }
        OptionSpace.register(module, instance);
    }

    public static void register(String module, OptionHolder holder) {
        if (HOLDERS.containsKey(module)) {
            LOG.warn("Already registered option holder: {} ({})", (Object)module, (Object)HOLDERS.get(module));
        }
        E.checkArgumentNotNull(holder, "OptionHolder can't be null", new Object[0]);
        HOLDERS.put(module, holder.getClass());
        OPTIONS.putAll(holder.options());
        LOG.debug("Registered options for OptionHolder: {}", (Object)holder.getClass().getSimpleName());
    }

    public static Set<String> keys() {
        return Collections.unmodifiableSet(OPTIONS.keySet());
    }

    public static boolean containKey(String key) {
        return OPTIONS.containsKey(key);
    }

    public static TypedOption<?, ?> get(String key) {
        return OPTIONS.get(key);
    }
}

