/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.driver.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hugegraph.util.E;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            String message = String.format("Can't write json: %s", e.getMessage());
            throw new RuntimeException(message, e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        E.checkState(json != null, "Json value can't be null for '%s'", clazz.getSimpleName());
        try {
            return OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            String message = String.format("Can't read json: %s", e.getMessage());
            throw new RuntimeException(message, e);
        }
    }

    static {
        OBJECT_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

