/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.util;

import org.apache.hugegraph.computer.core.common.exception.ComputerException;

public class CoderUtil {
    public static byte[] encode(String s2) {
        int i;
        char c;
        int strLen = s2.length();
        int utfLen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strLen; ++i2) {
            c = s2.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c > '\u07ff') {
                utfLen += 3;
                continue;
            }
            utfLen += 2;
        }
        byte[] bytes = new byte[utfLen];
        for (i = 0; i < strLen && (c = s2.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytes[count++] = (byte)c;
        }
        while (i < strLen) {
            c = s2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytes[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytes[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        return bytes;
    }

    public static String decode(byte[] bytes) {
        return CoderUtil.decode(bytes, 0, bytes.length);
    }

    public static String decode(byte[] bytes, int start, int length) {
        int c;
        int count;
        char[] chars = new char[length];
        int charIndex = 0;
        for (count = start; count < length && (c = bytes[count] & 0xFF) <= 127; ++count) {
            chars[charIndex++] = (char)c;
        }
        block6: while (count < length) {
            c = bytes[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chars[charIndex++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        throw new ComputerException("Malformed input: partial character at end");
                    }
                    byte char2 = bytes[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new ComputerException("Malformed input around byte " + count);
                    }
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > length) {
                        throw new ComputerException("Malformed input: partial character at end");
                    }
                    byte char2 = bytes[count - 2];
                    byte char3 = bytes[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new ComputerException("Malformed input around byte " + (count - 1));
                    }
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new ComputerException("Malformed input around byte " + count);
        }
        return new String(chars, 0, charIndex);
    }
}

