/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class StringValue
implements Value.Tvalue<String> {
    private String value;

    public StringValue() {
        this.value = "";
    }

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.STRING;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((StringValue)other).value;
    }

    @Override
    public StringValue copy() {
        return new StringValue(this.value);
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readUTF();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull(obj, "The compare argument can't be null", new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return this.value.compareTo(((StringValue)obj).value);
    }

    @Override
    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringValue)) {
            return false;
        }
        return ((StringValue)obj).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

