/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Readiable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.client.utils.DeleteAndCreateHelper;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<HasMetadata, HasMetadata>,
Readiable {
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final HasMetadata item;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean dryRun) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, (HasMetadata)NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is), -1L, null, cascading, watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier, dryRun);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, HasMetadata item, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean dryRun) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.checkForHandlerOf(item);
        this.cascading = cascading;
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.dryRun = dryRun;
        this.visitors.add(new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        String namespaceToUse = meta.getMetadata().getNamespace();
        if (Boolean.TRUE.equals(this.deletingExisting)) {
            return DeleteAndCreateHelper.deleteAndCreateItem(this.client, this.config, meta, h2, namespaceToUse, this.propagationPolicy, this.gracePeriodSeconds, this.dryRun);
        }
        return CreateOrReplaceHelper.createOrReplaceItem(this.client, this.config, meta, h2, namespaceToUse, this.dryRun);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Boolean delete() {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, this.gracePeriodSeconds, meta, this.dryRun);
    }

    @Override
    public HasMetadata get() {
        ResourceHandler<HasMetadata, ?> h2;
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(this.item, this.visitors);
        if (this.fromServer.booleanValue() && (meta = (h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta)).reload(this.client, this.config, meta.getMetadata().getNamespace(), meta)) != null) {
            return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(meta, this.visitors);
        }
        return meta;
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        for (Visitor v : visitors) {
            newVisitors.add(v);
        }
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<HasMetadata> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<HasMetadata> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Deletable cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        long watchRetryInitialBackoffMillis = backoffUnit.toMillis(initialBackoff);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, watchRetryInitialBackoffMillis, backoffMultiplier, this.dryRun);
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, resourceVersion, watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<HasMetadata> watcher) {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, options, watcher);
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    @Override
    public final boolean isReady() {
        HasMetadata meta = (HasMetadata)this.fromServer().get();
        if (meta == null) {
            return false;
        }
        return this.getReadiness().isReady(meta);
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit);
    }

    @Override
    public VisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, isDryRun);
    }

    @Override
    public HasMetadata waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        HasMetadata meta = this.get();
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h2.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit);
    }

    private static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors) {
        ResourceHandler<HasMetadata, ?> h2 = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        Object builder = h2.edit(item);
        for (Visitor v : visitors) {
            builder.accept(v);
        }
        return (HasMetadata)builder.build();
    }

    static <T> void checkForHandlerOf(T item) {
        if (item instanceof HasMetadata) {
            if (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf((HasMetadata)item) == null) {
                throw new KubernetesClientException("No handler found for object:" + item);
            }
        } else if (!(item instanceof KubernetesList)) {
            throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
        }
    }

    static <T extends HasMetadata> ResourceHandler<HasMetadata, ?> handlerOf(T item) {
        return Handlers.get(item.getKind(), item.getApiVersion());
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        @Override
        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

