/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class IntValue
extends Number
implements Value.Tvalue<Integer> {
    private static final long serialVersionUID = -2014388310992178979L;
    private int value;

    public IntValue() {
        this(0);
    }

    public IntValue(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public void value(int value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.INT;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((IntValue)other).value;
    }

    @Override
    public IntValue copy() {
        return new IntValue(this.value);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull((Object)obj, (String)"The compare argument can't be null", (Object[])new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return Integer.compare(this.value, ((IntValue)obj).value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntValue)) {
            return false;
        }
        return ((IntValue)obj).value == this.value;
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

