/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.rings.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.util.JsonUtil;

public class FilterDescribe {
    private final List<DescribeItem> vertexFilter;
    private final List<DescribeItem> edgeFilter;

    @JsonCreator
    private FilterDescribe(@JsonProperty(value="vertex_filter") List<DescribeItem> vertexFilter, @JsonProperty(value="edge_filter") List<DescribeItem> edgeFilter) {
        this.vertexFilter = CollectionUtils.isEmpty(vertexFilter) ? ImmutableList.of() : ImmutableList.copyOf(vertexFilter);
        this.edgeFilter = CollectionUtils.isEmpty(edgeFilter) ? ImmutableList.of() : ImmutableList.copyOf(edgeFilter);
    }

    public static FilterDescribe of(String describe) {
        return (FilterDescribe)JsonUtil.fromJson((String)describe, FilterDescribe.class);
    }

    public List<DescribeItem> vertexFilter() {
        return this.vertexFilter;
    }

    public List<DescribeItem> edgeFilter() {
        return this.edgeFilter;
    }

    public static class DescribeItem {
        private final String label;
        private final String propertyFilter;

        @JsonCreator
        private DescribeItem(@JsonProperty(value="label", required=true) String label, @JsonProperty(value="property_filter", required=true) String propertyFilter) {
            this.label = label;
            this.propertyFilter = propertyFilter;
        }

        public String label() {
            return this.label;
        }

        public String propertyFilter() {
            return this.propertyFilter;
        }
    }
}

