/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.community.kcore;

import java.io.IOException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.id.IdFactory;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class KcoreValue
implements Value.CustomizeValue<Object> {
    private int degree = 0;
    private Id core = IdFactory.createId();

    public void degree(int degree) {
        assert (degree >= 0);
        this.degree = degree;
    }

    public int degree() {
        return this.degree;
    }

    public int decreaseDegree(int decrease) {
        assert (decrease <= this.degree);
        this.degree -= decrease;
        return this.degree;
    }

    public boolean active() {
        return this.degree > 0;
    }

    public void core(Id core) {
        this.core = core;
    }

    public Id core() {
        E.checkNotNull((Object)this.core, (String)"core");
        return this.core;
    }

    public KcoreValue copy() {
        KcoreValue kcoreValue = new KcoreValue();
        kcoreValue.core = (Id)this.core.copy();
        kcoreValue.degree = this.degree;
        return kcoreValue;
    }

    public void read(RandomAccessInput in) throws IOException {
        this.core.read(in);
        this.degree = in.readInt();
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.core.write(out);
        out.writeInt(this.degree);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("core", (Object)this.core).append("degree", this.degree).toString();
    }

    public Object value() {
        return this.core.value();
    }
}

